
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "wrap.h"


LADSPA_Handle
INTERPOL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INTERPOL * i = new INTERPOL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INTERPOL_port_enum {
	INTERPOL_r_enum, INTERPOL_val1_enum, INTERPOL_val2_enum, INTERPOL_point_enum, INTERPOL_imin_enum, INTERPOL_imax_enum, 
};

void
INTERPOL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INTERPOL * ins = (INTERPOL *)Instance;
	switch(Port) {

		case INTERPOL_r_enum:
			ins->r = DataLocation;
			break;

		case INTERPOL_val1_enum:
			ins->val1 = DataLocation;
			break;

		case INTERPOL_val2_enum:
			ins->val2 = DataLocation;
			break;

		case INTERPOL_point_enum:
			ins->point = DataLocation;
			break;

		case INTERPOL_imin_enum:
			ins->imin = DataLocation;
			break;

		case INTERPOL_imax_enum:
			ins->imax = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
TRIG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TRIG * i = new TRIG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TRIG_port_enum {
	TRIG_kout_enum, TRIG_ksig_enum, TRIG_kthreshold_enum, TRIG_kmode_enum, 
};

void
TRIG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TRIG * ins = (TRIG *)Instance;
	switch(Port) {

		case TRIG_kout_enum:
			ins->kout = DataLocation;
			break;

		case TRIG_ksig_enum:
			ins->ksig = DataLocation;
			break;

		case TRIG_kthreshold_enum:
			ins->kthreshold = DataLocation;
			break;

		case TRIG_kmode_enum:
			ins->kmode = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
WRAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	WRAP * i = new WRAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum WRAP_port_enum {
	WRAP_xdest_enum, WRAP_xsig_enum, WRAP_xlow_enum, WRAP_xhigh_enum, 
};

void
WRAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	WRAP * ins = (WRAP *)Instance;
	switch(Port) {

		case WRAP_xdest_enum:
			ins->xdest = DataLocation;
			break;

		case WRAP_xsig_enum:
			ins->xsig = DataLocation;
			break;

		case WRAP_xlow_enum:
			ins->xlow = DataLocation;
			break;

		case WRAP_xhigh_enum:
			ins->xhigh = DataLocation;
			break;

		default:
			break;
	}
}

void
antrpol_activate(LADSPA_Handle Instance)
{
	INTERPOL * ins = (INTERPOL *)Instance;
	nterpol_init(ins);
}

void
antrpol_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INTERPOL * ins = (INTERPOL *)Instance;
	set_qcs_controlrate(SampleCount);
	anterpol(ins);
}

void
antrpol_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_antrpol_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "antrpol";
	d->Name = "antrpol";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="val1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="val2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="point";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="imin";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="imax";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INTERPOL_instantiate;
	d->connect_port = INTERPOL_connect_port;
	d->activate = antrpol_activate;
	d->run = antrpol_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = antrpol_cleanup;
	return d;
}

void
wrap_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	WRAP * ins = (WRAP *)Instance;
	set_qcs_controlrate(SampleCount);
	wrap(ins);
}

void
wrap_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_wrap_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "wrap";
	d->Name = "wrap";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="xdest";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xlow";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="xhigh";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = WRAP_instantiate;
	d->connect_port = WRAP_connect_port;
	d->activate = 0;
	d->run = wrap_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = wrap_cleanup;
	return d;
}

void
intrpol_activate(LADSPA_Handle Instance)
{
	INTERPOL * ins = (INTERPOL *)Instance;
	interpol(ins);
}

void
intrpol_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INTERPOL * ins = (INTERPOL *)Instance;
	set_qcs_controlrate(SampleCount);
	knterpol(ins);
}

void
intrpol_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_intrpol_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "intrpol";
	d->Name = "intrpol";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="val1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="val2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="point";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="imin";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="imax";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INTERPOL_instantiate;
	d->connect_port = INTERPOL_connect_port;
	d->activate = intrpol_activate;
	d->run = intrpol_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = intrpol_cleanup;
	return d;
}

void
mirror_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	WRAP * ins = (WRAP *)Instance;
	set_qcs_controlrate(SampleCount);
	mirror(ins);
}

void
mirror_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mirror_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mirror";
	d->Name = "mirror";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="xdest";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xlow";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="xhigh";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = WRAP_instantiate;
	d->connect_port = WRAP_connect_port;
	d->activate = 0;
	d->run = mirror_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mirror_cleanup;
	return d;
}

enum descriptor_enum {
	antrpol_desc_enum, intrpol_desc_enum, mirror_desc_enum, wrap_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *antrpol_desc_pointer;
	static LADSPA_Descriptor *intrpol_desc_pointer;
	static LADSPA_Descriptor *mirror_desc_pointer;
	static LADSPA_Descriptor *wrap_desc_pointer;

	if (!inited) {
		antrpol_desc_pointer = new_antrpol_desc();
		intrpol_desc_pointer = new_intrpol_desc();
		mirror_desc_pointer = new_mirror_desc();
		wrap_desc_pointer = new_wrap_desc();

		inited=true;
	}
	
	switch(Index) {
		case antrpol_desc_enum : return antrpol_desc_pointer;
		case intrpol_desc_enum : return intrpol_desc_pointer;
		case mirror_desc_enum : return mirror_desc_pointer;
		case wrap_desc_enum : return wrap_desc_pointer;

		default:
			return 0;
	}
}
