
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "vibraphn.h"


LADSPA_Handle
VIBRAPHN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	VIBRAPHN * i = new VIBRAPHN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum VIBRAPHN_port_enum {
	VIBRAPHN_ar_enum, VIBRAPHN_amplitude_enum, VIBRAPHN_frequency_enum, VIBRAPHN_hardness_enum, VIBRAPHN_spos_enum, VIBRAPHN_ifn_enum, VIBRAPHN_vibFreq_enum, VIBRAPHN_vibAmt_enum, VIBRAPHN_ivfn_enum, VIBRAPHN_dettack_enum, 
};

void
VIBRAPHN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	VIBRAPHN * ins = (VIBRAPHN *)Instance;
	switch(Port) {

		case VIBRAPHN_ar_enum:
			ins->ar = DataLocation;
			break;

		case VIBRAPHN_amplitude_enum:
			ins->amplitude = DataLocation;
			break;

		case VIBRAPHN_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case VIBRAPHN_hardness_enum:
			ins->hardness = DataLocation;
			break;

		case VIBRAPHN_spos_enum:
			ins->spos = DataLocation;
			break;

		case VIBRAPHN_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case VIBRAPHN_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case VIBRAPHN_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case VIBRAPHN_ivfn_enum:
			ins->ivfn = DataLocation;
			break;

		case VIBRAPHN_dettack_enum:
			ins->dettack = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
gogobel_activate(LADSPA_Handle Instance)
{
	VIBRAPHN * ins = (VIBRAPHN *)Instance;
	agogobelset(ins);
}

void
gogobel_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	VIBRAPHN * ins = (VIBRAPHN *)Instance;
	set_qcs_controlrate(SampleCount);
	agogobel(ins);
}

void
gogobel_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gogobel_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gogobel";
	d->Name = "gogobel";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amplitude";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="hardness";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="spos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ivfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = VIBRAPHN_instantiate;
	d->connect_port = VIBRAPHN_connect_port;
	d->activate = gogobel_activate;
	d->run = gogobel_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gogobel_cleanup;
	return d;
}

void
vibes_activate(LADSPA_Handle Instance)
{
	VIBRAPHN * ins = (VIBRAPHN *)Instance;
	vibraphnset(ins);
}

void
vibes_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	VIBRAPHN * ins = (VIBRAPHN *)Instance;
	set_qcs_controlrate(SampleCount);
	vibraphn(ins);
}

void
vibes_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_vibes_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "vibes";
	d->Name = "vibes";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 10;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amplitude";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="hardness";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="spos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ivfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = VIBRAPHN_instantiate;
	d->connect_port = VIBRAPHN_connect_port;
	d->activate = vibes_activate;
	d->run = vibes_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = vibes_cleanup;
	return d;
}

enum descriptor_enum {
	vibes_desc_enum, gogobel_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *vibes_desc_pointer;
	static LADSPA_Descriptor *gogobel_desc_pointer;

	if (!inited) {
		vibes_desc_pointer = new_vibes_desc();
		gogobel_desc_pointer = new_gogobel_desc();

		inited=true;
	}
	
	switch(Index) {
		case vibes_desc_enum : return vibes_desc_pointer;
		case gogobel_desc_enum : return gogobel_desc_pointer;

		default:
			return 0;
	}
}
