
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens5.h"


LADSPA_Handle
PORT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PORT * i = new PORT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PORT_port_enum {
	PORT_kr_enum, PORT_ksig_enum, PORT_ihtim_enum, PORT_isig_enum, 
};

void
PORT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PORT * ins = (PORT *)Instance;
	switch(Port) {

		case PORT_kr_enum:
			ins->kr = DataLocation;
			break;

		case PORT_ksig_enum:
			ins->ksig = DataLocation;
			break;

		case PORT_ihtim_enum:
			ins->ihtim = DataLocation;
			break;

		case PORT_isig_enum:
			ins->isig = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
TONEX_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TONEX * i = new TONEX;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TONEX_port_enum {
	TONEX_ar_enum, TONEX_asig_enum, TONEX_khp_enum, TONEX_ord_enum, TONEX_istor_enum, TONEX_yt1_enum, 
};

void
TONEX_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TONEX * ins = (TONEX *)Instance;
	switch(Port) {

		case TONEX_ar_enum:
			ins->ar = DataLocation;
			break;

		case TONEX_asig_enum:
			ins->asig = DataLocation;
			break;

		case TONEX_khp_enum:
			ins->khp = DataLocation;
			break;

		case TONEX_ord_enum:
			ins->ord = DataLocation;
			break;

		case TONEX_istor_enum:
			ins->istor = DataLocation;
			break;

		case TONEX_yt1_enum:
			ins->yt1 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RMS_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RMS * i = new RMS;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RMS_port_enum {
	RMS_kr_enum, RMS_asig_enum, RMS_ihp_enum, RMS_istor_enum, 
};

void
RMS_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RMS * ins = (RMS *)Instance;
	switch(Port) {

		case RMS_kr_enum:
			ins->kr = DataLocation;
			break;

		case RMS_asig_enum:
			ins->asig = DataLocation;
			break;

		case RMS_ihp_enum:
			ins->ihp = DataLocation;
			break;

		case RMS_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BALANCE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BALANCE * i = new BALANCE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BALANCE_port_enum {
	BALANCE_ar_enum, BALANCE_asig_enum, BALANCE_csig_enum, BALANCE_ihp_enum, BALANCE_istor_enum, 
};

void
BALANCE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BALANCE * ins = (BALANCE *)Instance;
	switch(Port) {

		case BALANCE_ar_enum:
			ins->ar = DataLocation;
			break;

		case BALANCE_asig_enum:
			ins->asig = DataLocation;
			break;

		case BALANCE_csig_enum:
			ins->csig = DataLocation;
			break;

		case BALANCE_ihp_enum:
			ins->ihp = DataLocation;
			break;

		case BALANCE_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RESONX_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RESONX * i = new RESONX;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RESONX_port_enum {
	RESONX_ar_enum, RESONX_asig_enum, RESONX_kcf_enum, RESONX_kbw_enum, RESONX_ord_enum, RESONX_iscl_enum, RESONX_istor_enum, 
};

void
RESONX_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RESONX * ins = (RESONX *)Instance;
	switch(Port) {

		case RESONX_ar_enum:
			ins->ar = DataLocation;
			break;

		case RESONX_asig_enum:
			ins->asig = DataLocation;
			break;

		case RESONX_kcf_enum:
			ins->kcf = DataLocation;
			break;

		case RESONX_kbw_enum:
			ins->kbw = DataLocation;
			break;

		case RESONX_ord_enum:
			ins->ord = DataLocation;
			break;

		case RESONX_iscl_enum:
			ins->iscl = DataLocation;
			break;

		case RESONX_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RESON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RESON * i = new RESON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RESON_port_enum {
	RESON_ar_enum, RESON_asig_enum, RESON_kcf_enum, RESON_kbw_enum, RESON_iscl_enum, RESON_istor_enum, 
};

void
RESON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RESON * ins = (RESON *)Instance;
	switch(Port) {

		case RESON_ar_enum:
			ins->ar = DataLocation;
			break;

		case RESON_asig_enum:
			ins->asig = DataLocation;
			break;

		case RESON_kcf_enum:
			ins->kcf = DataLocation;
			break;

		case RESON_kbw_enum:
			ins->kbw = DataLocation;
			break;

		case RESON_iscl_enum:
			ins->iscl = DataLocation;
			break;

		case RESON_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
GAIN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	GAIN * i = new GAIN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum GAIN_port_enum {
	GAIN_ar_enum, GAIN_asig_enum, GAIN_krms_enum, GAIN_ihp_enum, GAIN_istor_enum, 
};

void
GAIN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	GAIN * ins = (GAIN *)Instance;
	switch(Port) {

		case GAIN_ar_enum:
			ins->ar = DataLocation;
			break;

		case GAIN_asig_enum:
			ins->asig = DataLocation;
			break;

		case GAIN_krms_enum:
			ins->krms = DataLocation;
			break;

		case GAIN_ihp_enum:
			ins->ihp = DataLocation;
			break;

		case GAIN_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
TONE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TONE * i = new TONE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TONE_port_enum {
	TONE_ar_enum, TONE_asig_enum, TONE_khp_enum, TONE_istor_enum, 
};

void
TONE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TONE * ins = (TONE *)Instance;
	switch(Port) {

		case TONE_ar_enum:
			ins->ar = DataLocation;
			break;

		case TONE_asig_enum:
			ins->asig = DataLocation;
			break;

		case TONE_khp_enum:
			ins->khp = DataLocation;
			break;

		case TONE_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
areson_activate(LADSPA_Handle Instance)
{
	RESON * ins = (RESON *)Instance;
	rsnset(ins);
}

void
areson_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RESON * ins = (RESON *)Instance;
	set_qcs_controlrate(SampleCount);
	areson(ins);
}

void
areson_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_areson_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "areson";
	d->Name = "areson";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RESON_instantiate;
	d->connect_port = RESON_connect_port;
	d->activate = areson_activate;
	d->run = areson_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = areson_cleanup;
	return d;
}

void
tonex_activate(LADSPA_Handle Instance)
{
	TONEX * ins = (TONEX *)Instance;
	tonsetx(ins);
}

void
tonex_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TONEX * ins = (TONEX *)Instance;
	set_qcs_controlrate(SampleCount);
	tonex(ins);
}

void
tonex_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tonex_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tonex";
	d->Name = "tonex";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="khp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TONEX_instantiate;
	d->connect_port = TONEX_connect_port;
	d->activate = tonex_activate;
	d->run = tonex_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tonex_cleanup;
	return d;
}

void
resonx_activate(LADSPA_Handle Instance)
{
	RESONX * ins = (RESONX *)Instance;
	rsnsetx(ins);
}

void
resonx_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RESONX * ins = (RESONX *)Instance;
	set_qcs_controlrate(SampleCount);
	resonx(ins);
}

void
resonx_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_resonx_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "resonx";
	d->Name = "resonx";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RESONX_instantiate;
	d->connect_port = RESONX_connect_port;
	d->activate = resonx_activate;
	d->run = resonx_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = resonx_cleanup;
	return d;
}

void
reson_activate(LADSPA_Handle Instance)
{
	RESON * ins = (RESON *)Instance;
	rsnset(ins);
}

void
reson_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RESON * ins = (RESON *)Instance;
	set_qcs_controlrate(SampleCount);
	reson(ins);
}

void
reson_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_reson_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "reson";
	d->Name = "reson";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RESON_instantiate;
	d->connect_port = RESON_connect_port;
	d->activate = reson_activate;
	d->run = reson_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = reson_cleanup;
	return d;
}

void
balance_activate(LADSPA_Handle Instance)
{
	BALANCE * ins = (BALANCE *)Instance;
	balnset(ins);
}

void
balance_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BALANCE * ins = (BALANCE *)Instance;
	set_qcs_controlrate(SampleCount);
	balance(ins);
}

void
balance_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_balance_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "balance";
	d->Name = "balance";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="csig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ihp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BALANCE_instantiate;
	d->connect_port = BALANCE_connect_port;
	d->activate = balance_activate;
	d->run = balance_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = balance_cleanup;
	return d;
}

void
gain_activate(LADSPA_Handle Instance)
{
	GAIN * ins = (GAIN *)Instance;
	gainset(ins);
}

void
gain_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	GAIN * ins = (GAIN *)Instance;
	set_qcs_controlrate(SampleCount);
	gain(ins);
}

void
gain_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gain_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gain";
	d->Name = "gain";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="krms";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ihp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = GAIN_instantiate;
	d->connect_port = GAIN_connect_port;
	d->activate = gain_activate;
	d->run = gain_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gain_cleanup;
	return d;
}

void
tone_activate(LADSPA_Handle Instance)
{
	TONE * ins = (TONE *)Instance;
	tonset(ins);
}

void
tone_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TONE * ins = (TONE *)Instance;
	set_qcs_controlrate(SampleCount);
	tone(ins);
}

void
tone_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tone_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tone";
	d->Name = "tone";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="khp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TONE_instantiate;
	d->connect_port = TONE_connect_port;
	d->activate = tone_activate;
	d->run = tone_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tone_cleanup;
	return d;
}

void
atonex_activate(LADSPA_Handle Instance)
{
	TONEX * ins = (TONEX *)Instance;
	tonsetx(ins);
}

void
atonex_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TONEX * ins = (TONEX *)Instance;
	set_qcs_controlrate(SampleCount);
	atonex(ins);
}

void
atonex_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_atonex_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "atonex";
	d->Name = "atonex";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="khp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TONEX_instantiate;
	d->connect_port = TONEX_connect_port;
	d->activate = atonex_activate;
	d->run = atonex_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = atonex_cleanup;
	return d;
}

void
atone_activate(LADSPA_Handle Instance)
{
	TONE * ins = (TONE *)Instance;
	tonset(ins);
}

void
atone_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TONE * ins = (TONE *)Instance;
	set_qcs_controlrate(SampleCount);
	atone(ins);
}

void
atone_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_atone_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "atone";
	d->Name = "atone";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="khp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TONE_instantiate;
	d->connect_port = TONE_connect_port;
	d->activate = atone_activate;
	d->run = atone_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = atone_cleanup;
	return d;
}

enum descriptor_enum {
	tonex_desc_enum, areson_desc_enum, balance_desc_enum, resonx_desc_enum, reson_desc_enum, gain_desc_enum, tone_desc_enum, atonex_desc_enum, atone_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *tonex_desc_pointer;
	static LADSPA_Descriptor *areson_desc_pointer;
	static LADSPA_Descriptor *balance_desc_pointer;
	static LADSPA_Descriptor *resonx_desc_pointer;
	static LADSPA_Descriptor *reson_desc_pointer;
	static LADSPA_Descriptor *gain_desc_pointer;
	static LADSPA_Descriptor *tone_desc_pointer;
	static LADSPA_Descriptor *atonex_desc_pointer;
	static LADSPA_Descriptor *atone_desc_pointer;

	if (!inited) {
		tonex_desc_pointer = new_tonex_desc();
		areson_desc_pointer = new_areson_desc();
		balance_desc_pointer = new_balance_desc();
		resonx_desc_pointer = new_resonx_desc();
		reson_desc_pointer = new_reson_desc();
		gain_desc_pointer = new_gain_desc();
		tone_desc_pointer = new_tone_desc();
		atonex_desc_pointer = new_atonex_desc();
		atone_desc_pointer = new_atone_desc();

		inited=true;
	}
	
	switch(Index) {
		case tonex_desc_enum : return tonex_desc_pointer;
		case areson_desc_enum : return areson_desc_pointer;
		case balance_desc_enum : return balance_desc_pointer;
		case resonx_desc_enum : return resonx_desc_pointer;
		case reson_desc_enum : return reson_desc_pointer;
		case gain_desc_enum : return gain_desc_pointer;
		case tone_desc_enum : return tone_desc_pointer;
		case atonex_desc_enum : return atonex_desc_pointer;
		case atone_desc_enum : return atone_desc_pointer;

		default:
			return 0;
	}
}
