
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens4.h"


LADSPA_Handle
PLUCK_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PLUCK * i = new PLUCK;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PLUCK_port_enum {
	PLUCK_ar_enum, PLUCK_kamp_enum, PLUCK_kcps_enum, PLUCK_icps_enum, PLUCK_ifn_enum, PLUCK_imeth_enum, PLUCK_ipar1_enum, PLUCK_ipar2_enum, 
};

void
PLUCK_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PLUCK * ins = (PLUCK *)Instance;
	switch(Port) {

		case PLUCK_ar_enum:
			ins->ar = DataLocation;
			break;

		case PLUCK_kamp_enum:
			ins->kamp = DataLocation;
			break;

		case PLUCK_kcps_enum:
			ins->kcps = DataLocation;
			break;

		case PLUCK_icps_enum:
			ins->icps = DataLocation;
			break;

		case PLUCK_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case PLUCK_imeth_enum:
			ins->imeth = DataLocation;
			break;

		case PLUCK_ipar1_enum:
			ins->ipar1 = DataLocation;
			break;

		case PLUCK_ipar2_enum:
			ins->ipar2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
BUZZ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BUZZ * i = new BUZZ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BUZZ_port_enum {
	BUZZ_ar_enum, BUZZ_xamp_enum, BUZZ_xcps_enum, BUZZ_knh_enum, BUZZ_ifn_enum, BUZZ_iphs_enum, 
};

void
BUZZ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BUZZ * ins = (BUZZ *)Instance;
	switch(Port) {

		case BUZZ_ar_enum:
			ins->ar = DataLocation;
			break;

		case BUZZ_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case BUZZ_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case BUZZ_knh_enum:
			ins->knh = DataLocation;
			break;

		case BUZZ_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case BUZZ_iphs_enum:
			ins->iphs = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RANDI_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RANDI * i = new RANDI;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RANDI_port_enum {
	RANDI_ar_enum, RANDI_xamp_enum, RANDI_xcps_enum, RANDI_iseed_enum, 
};

void
RANDI_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RANDI * ins = (RANDI *)Instance;
	switch(Port) {

		case RANDI_ar_enum:
			ins->ar = DataLocation;
			break;

		case RANDI_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case RANDI_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case RANDI_iseed_enum:
			ins->iseed = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RANDH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RANDH * i = new RANDH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RANDH_port_enum {
	RANDH_ar_enum, RANDH_xamp_enum, RANDH_xcps_enum, RANDH_iseed_enum, 
};

void
RANDH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RANDH * ins = (RANDH *)Instance;
	switch(Port) {

		case RANDH_ar_enum:
			ins->ar = DataLocation;
			break;

		case RANDH_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case RANDH_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case RANDH_iseed_enum:
			ins->iseed = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
GBUZZ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	GBUZZ * i = new GBUZZ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum GBUZZ_port_enum {
	GBUZZ_ar_enum, GBUZZ_xamp_enum, GBUZZ_xcps_enum, GBUZZ_kn_enum, GBUZZ_kk_enum, GBUZZ_kr_enum, GBUZZ_ifn_enum, GBUZZ_iphs_enum, 
};

void
GBUZZ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	GBUZZ * ins = (GBUZZ *)Instance;
	switch(Port) {

		case GBUZZ_ar_enum:
			ins->ar = DataLocation;
			break;

		case GBUZZ_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case GBUZZ_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case GBUZZ_kn_enum:
			ins->kn = DataLocation;
			break;

		case GBUZZ_kk_enum:
			ins->kk = DataLocation;
			break;

		case GBUZZ_kr_enum:
			ins->kr = DataLocation;
			break;

		case GBUZZ_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case GBUZZ_iphs_enum:
			ins->iphs = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RAND_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RAND * i = new RAND;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RAND_port_enum {
	RAND_ar_enum, RAND_xamp_enum, RAND_iseed_enum, 
};

void
RAND_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RAND * ins = (RAND *)Instance;
	switch(Port) {

		case RAND_ar_enum:
			ins->ar = DataLocation;
			break;

		case RAND_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case RAND_iseed_enum:
			ins->iseed = DataLocation;
			break;

		default:
			break;
	}
}

void
buzz_activate(LADSPA_Handle Instance)
{
	BUZZ * ins = (BUZZ *)Instance;
	bzzset(ins);
}

void
buzz_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BUZZ * ins = (BUZZ *)Instance;
	set_qcs_controlrate(SampleCount);
	buzz(ins);
}

void
buzz_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_buzz_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "buzz";
	d->Name = "buzz";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="knh";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BUZZ_instantiate;
	d->connect_port = BUZZ_connect_port;
	d->activate = buzz_activate;
	d->run = buzz_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = buzz_cleanup;
	return d;
}

void
pluck_activate(LADSPA_Handle Instance)
{
	PLUCK * ins = (PLUCK *)Instance;
	plukset(ins);
}

void
pluck_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PLUCK * ins = (PLUCK *)Instance;
	set_qcs_controlrate(SampleCount);
	pluck(ins);
}

void
pluck_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pluck_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pluck";
	d->Name = "pluck";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 8;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="kamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="icps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="imeth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ipar1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ipar2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PLUCK_instantiate;
	d->connect_port = PLUCK_connect_port;
	d->activate = pluck_activate;
	d->run = pluck_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pluck_cleanup;
	return d;
}

void
randi_activate(LADSPA_Handle Instance)
{
	RANDI * ins = (RANDI *)Instance;
	riset(ins);
}

void
randi_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RANDI * ins = (RANDI *)Instance;
	set_qcs_controlrate(SampleCount);
	randi(ins);
}

void
randi_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_randi_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "randi";
	d->Name = "randi";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="iseed";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RANDI_instantiate;
	d->connect_port = RANDI_connect_port;
	d->activate = randi_activate;
	d->run = randi_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = randi_cleanup;
	return d;
}

void
randh_activate(LADSPA_Handle Instance)
{
	RANDH * ins = (RANDH *)Instance;
	rhset(ins);
}

void
randh_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RANDH * ins = (RANDH *)Instance;
	set_qcs_controlrate(SampleCount);
	randh(ins);
}

void
randh_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_randh_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "randh";
	d->Name = "randh";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="iseed";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RANDH_instantiate;
	d->connect_port = RANDH_connect_port;
	d->activate = randh_activate;
	d->run = randh_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = randh_cleanup;
	return d;
}

void
gbuzz_activate(LADSPA_Handle Instance)
{
	GBUZZ * ins = (GBUZZ *)Instance;
	gbzset(ins);
}

void
gbuzz_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	GBUZZ * ins = (GBUZZ *)Instance;
	set_qcs_controlrate(SampleCount);
	gbuzz(ins);
}

void
gbuzz_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gbuzz_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gbuzz";
	d->Name = "gbuzz";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 8;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="kk";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = GBUZZ_instantiate;
	d->connect_port = GBUZZ_connect_port;
	d->activate = gbuzz_activate;
	d->run = gbuzz_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gbuzz_cleanup;
	return d;
}

void
rand_activate(LADSPA_Handle Instance)
{
	RAND * ins = (RAND *)Instance;
	rndset(ins);
}

void
rand_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RAND * ins = (RAND *)Instance;
	set_qcs_controlrate(SampleCount);
	arand(ins);
}

void
rand_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_rand_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "rand";
	d->Name = "rand";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="iseed";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RAND_instantiate;
	d->connect_port = RAND_connect_port;
	d->activate = rand_activate;
	d->run = rand_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = rand_cleanup;
	return d;
}

enum descriptor_enum {
	buzz_desc_enum, pluck_desc_enum, randi_desc_enum, randh_desc_enum, gbuzz_desc_enum, rand_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *buzz_desc_pointer;
	static LADSPA_Descriptor *pluck_desc_pointer;
	static LADSPA_Descriptor *randi_desc_pointer;
	static LADSPA_Descriptor *randh_desc_pointer;
	static LADSPA_Descriptor *gbuzz_desc_pointer;
	static LADSPA_Descriptor *rand_desc_pointer;

	if (!inited) {
		buzz_desc_pointer = new_buzz_desc();
		pluck_desc_pointer = new_pluck_desc();
		randi_desc_pointer = new_randi_desc();
		randh_desc_pointer = new_randh_desc();
		gbuzz_desc_pointer = new_gbuzz_desc();
		rand_desc_pointer = new_rand_desc();

		inited=true;
	}
	
	switch(Index) {
		case buzz_desc_enum : return buzz_desc_pointer;
		case pluck_desc_enum : return pluck_desc_pointer;
		case randi_desc_enum : return randi_desc_pointer;
		case randh_desc_enum : return randh_desc_pointer;
		case gbuzz_desc_enum : return gbuzz_desc_pointer;
		case rand_desc_enum : return rand_desc_pointer;

		default:
			return 0;
	}
}
