
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens3.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
FOSC_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FOSC * i = new FOSC;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FOSC_port_enum {
	FOSC_rslt_enum, FOSC_xamp_enum, FOSC_kcps_enum, FOSC_kcar_enum, FOSC_kmod_enum, FOSC_kndx_enum, FOSC_ifn_enum, FOSC_iphs_enum, 
};

void
FOSC_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FOSC * ins = (FOSC *)Instance;
	switch(Port) {

		case FOSC_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case FOSC_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case FOSC_kcps_enum:
			ins->kcps = DataLocation;
			break;

		case FOSC_kcar_enum:
			ins->kcar = DataLocation;
			break;

		case FOSC_kmod_enum:
			ins->kmod = DataLocation;
			break;

		case FOSC_kndx_enum:
			ins->kndx = DataLocation;
			break;

		case FOSC_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case FOSC_iphs_enum:
			ins->iphs = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
ADSYN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ADSYN * i = new ADSYN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ADSYN_port_enum {
	ADSYN_rslt_enum, ADSYN_kamod_enum, ADSYN_kfmod_enum, ADSYN_ksmod_enum, ADSYN_ifilcod_enum, ADSYN_dum_enum, 
};

void
ADSYN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ADSYN * ins = (ADSYN *)Instance;
	switch(Port) {

		case ADSYN_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case ADSYN_kamod_enum:
			ins->kamod = DataLocation;
			break;

		case ADSYN_kfmod_enum:
			ins->kfmod = DataLocation;
			break;

		case ADSYN_ksmod_enum:
			ins->ksmod = DataLocation;
			break;

		case ADSYN_ifilcod_enum:
			ins->ifilcod = DataLocation;
			break;

		case ADSYN_dum_enum:
			ins->dum = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LOSC_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LOSC * i = new LOSC;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LOSC_port_enum {
	LOSC_ar1_enum, LOSC_ar2_enum, LOSC_xamp_enum, LOSC_kcps_enum, LOSC_ifn_enum, LOSC_ibas_enum, LOSC_imod1_enum, LOSC_ibeg1_enum, LOSC_iend1_enum, LOSC_imod2_enum, LOSC_ibeg2_enum, LOSC_iend2_enum, 
};

void
LOSC_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LOSC * ins = (LOSC *)Instance;
	switch(Port) {

		case LOSC_ar1_enum:
			ins->ar1 = DataLocation;
			break;

		case LOSC_ar2_enum:
			ins->ar2 = DataLocation;
			break;

		case LOSC_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case LOSC_kcps_enum:
			ins->kcps = DataLocation;
			break;

		case LOSC_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case LOSC_ibas_enum:
			ins->ibas = DataLocation;
			break;

		case LOSC_imod1_enum:
			ins->imod1 = DataLocation;
			break;

		case LOSC_ibeg1_enum:
			ins->ibeg1 = DataLocation;
			break;

		case LOSC_iend1_enum:
			ins->iend1 = DataLocation;
			break;

		case LOSC_imod2_enum:
			ins->imod2 = DataLocation;
			break;

		case LOSC_ibeg2_enum:
			ins->ibeg2 = DataLocation;
			break;

		case LOSC_iend2_enum:
			ins->iend2 = DataLocation;
			break;

		default:
			break;
	}
}

void
foscili_activate(LADSPA_Handle Instance)
{
	FOSC * ins = (FOSC *)Instance;
	foscset(ins);
}

void
foscili_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FOSC * ins = (FOSC *)Instance;
	set_qcs_controlrate(SampleCount);
	foscili(ins);
}

void
foscili_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_foscili_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "foscili";
	d->Name = "foscili";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 8;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kcar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="kmod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FOSC_instantiate;
	d->connect_port = FOSC_connect_port;
	d->activate = foscili_activate;
	d->run = foscili_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = foscili_cleanup;
	return d;
}

void
foscil_activate(LADSPA_Handle Instance)
{
	FOSC * ins = (FOSC *)Instance;
	foscset(ins);
}

void
foscil_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FOSC * ins = (FOSC *)Instance;
	set_qcs_controlrate(SampleCount);
	foscil(ins);
}

void
foscil_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_foscil_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "foscil";
	d->Name = "foscil";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 8;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kcar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="kmod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FOSC_instantiate;
	d->connect_port = FOSC_connect_port;
	d->activate = foscil_activate;
	d->run = foscil_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = foscil_cleanup;
	return d;
}

void
adsyn_activate(LADSPA_Handle Instance)
{
	ADSYN * ins = (ADSYN *)Instance;
	adset(ins);
}

void
adsyn_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ADSYN * ins = (ADSYN *)Instance;
	set_qcs_controlrate(SampleCount);
	adsyn(ins);
}

void
adsyn_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_adsyn_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "adsyn";
	d->Name = "adsyn";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="kamod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfmod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ksmod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ifilcod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="dum";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ADSYN_instantiate;
	d->connect_port = ADSYN_connect_port;
	d->activate = adsyn_activate;
	d->run = adsyn_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = adsyn_cleanup;
	return d;
}

void
loscil_activate(LADSPA_Handle Instance)
{
	LOSC * ins = (LOSC *)Instance;
	losset(ins);
}

void
loscil_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOSC * ins = (LOSC *)Instance;
	set_qcs_controlrate(SampleCount);
	loscil(ins);
}

void
loscil_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_loscil_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "loscil";
	d->Name = "loscil";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="ar2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="ibas";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="imod1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ibeg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="iend1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="imod2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ibeg2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="iend2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOSC_instantiate;
	d->connect_port = LOSC_connect_port;
	d->activate = loscil_activate;
	d->run = loscil_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = loscil_cleanup;
	return d;
}

enum descriptor_enum {
	foscili_desc_enum, foscil_desc_enum, adsyn_desc_enum, loscil_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *foscili_desc_pointer;
	static LADSPA_Descriptor *foscil_desc_pointer;
	static LADSPA_Descriptor *adsyn_desc_pointer;
	static LADSPA_Descriptor *loscil_desc_pointer;

	if (!inited) {
		foscili_desc_pointer = new_foscili_desc();
		foscil_desc_pointer = new_foscil_desc();
		adsyn_desc_pointer = new_adsyn_desc();
		loscil_desc_pointer = new_loscil_desc();

		inited=true;
	}
	
	switch(Index) {
		case foscili_desc_enum : return foscili_desc_pointer;
		case foscil_desc_enum : return foscil_desc_pointer;
		case adsyn_desc_enum : return adsyn_desc_pointer;
		case loscil_desc_enum : return loscil_desc_pointer;

		default:
			return 0;
	}
}
