
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens2.h"


LADSPA_Handle
OSCILN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OSCILN * i = new OSCILN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OSCILN_port_enum {
	OSCILN_rslt_enum, OSCILN_kamp_enum, OSCILN_ifrq_enum, OSCILN_ifn_enum, OSCILN_itimes_enum, 
};

void
OSCILN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OSCILN * ins = (OSCILN *)Instance;
	switch(Port) {

		case OSCILN_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case OSCILN_kamp_enum:
			ins->kamp = DataLocation;
			break;

		case OSCILN_ifrq_enum:
			ins->ifrq = DataLocation;
			break;

		case OSCILN_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case OSCILN_itimes_enum:
			ins->itimes = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PHSOR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PHSOR * i = new PHSOR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PHSOR_port_enum {
	PHSOR_sr_enum, PHSOR_xcps_enum, PHSOR_iphs_enum, 
};

void
PHSOR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PHSOR * ins = (PHSOR *)Instance;
	switch(Port) {

		case PHSOR_sr_enum:
			ins->sr = DataLocation;
			break;

		case PHSOR_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case PHSOR_iphs_enum:
			ins->iphs = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OSCIL1_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OSCIL1 * i = new OSCIL1;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OSCIL1_port_enum {
	OSCIL1_rslt_enum, OSCIL1_idel_enum, OSCIL1_kamp_enum, OSCIL1_idur_enum, OSCIL1_ifn_enum, 
};

void
OSCIL1_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OSCIL1 * ins = (OSCIL1 *)Instance;
	switch(Port) {

		case OSCIL1_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case OSCIL1_idel_enum:
			ins->idel = DataLocation;
			break;

		case OSCIL1_kamp_enum:
			ins->kamp = DataLocation;
			break;

		case OSCIL1_idur_enum:
			ins->idur = DataLocation;
			break;

		case OSCIL1_ifn_enum:
			ins->ifn = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
TABLE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TABLE * i = new TABLE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TABLE_port_enum {
	TABLE_rslt_enum, TABLE_xndx_enum, TABLE_xfn_enum, TABLE_ixmode_enum, TABLE_ixoff_enum, TABLE_iwrap_enum, 
};

void
TABLE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TABLE * ins = (TABLE *)Instance;
	switch(Port) {

		case TABLE_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case TABLE_xndx_enum:
			ins->xndx = DataLocation;
			break;

		case TABLE_xfn_enum:
			ins->xfn = DataLocation;
			break;

		case TABLE_ixmode_enum:
			ins->ixmode = DataLocation;
			break;

		case TABLE_ixoff_enum:
			ins->ixoff = DataLocation;
			break;

		case TABLE_iwrap_enum:
			ins->iwrap = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OSC_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OSC * i = new OSC;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OSC_port_enum {
	OSC_sr_enum, OSC_xamp_enum, OSC_xcps_enum, OSC_ifn_enum, OSC_iphs_enum, 
};

void
OSC_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OSC * ins = (OSC *)Instance;
	switch(Port) {

		case OSC_sr_enum:
			ins->sr = DataLocation;
			break;

		case OSC_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case OSC_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case OSC_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case OSC_iphs_enum:
			ins->iphs = DataLocation;
			break;

		default:
			break;
	}
}

void
tablei_activate(LADSPA_Handle Instance)
{
	TABLE * ins = (TABLE *)Instance;
	tblset(ins);
}

void
tablei_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TABLE * ins = (TABLE *)Instance;
	set_qcs_controlrate(SampleCount);
	tabli(ins);
}

void
tablei_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tablei_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tablei";
	d->Name = "tablei";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ixmode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ixoff";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iwrap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TABLE_instantiate;
	d->connect_port = TABLE_connect_port;
	d->activate = tablei_activate;
	d->run = tablei_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tablei_cleanup;
	return d;
}

void
oscil_kk_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscil_kk_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	osckk(ins);
}

void
oscil_kk_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscil_kk_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscil_kk";
	d->Name = "oscil_kk";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscil_kk_activate;
	d->run = oscil_kk_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscil_kk_cleanup;
	return d;
}

void
phasor_activate(LADSPA_Handle Instance)
{
	PHSOR * ins = (PHSOR *)Instance;
	phsset(ins);
}

void
phasor_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PHSOR * ins = (PHSOR *)Instance;
	set_qcs_controlrate(SampleCount);
	phsor(ins);
}

void
phasor_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_phasor_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "phasor";
	d->Name = "phasor";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PHSOR_instantiate;
	d->connect_port = PHSOR_connect_port;
	d->activate = phasor_activate;
	d->run = phasor_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = phasor_cleanup;
	return d;
}

void
oscili_ak_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscili_ak_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	oscaki(ins);
}

void
oscili_ak_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscili_ak_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscili_ak";
	d->Name = "oscili_ak";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscili_ak_activate;
	d->run = oscili_ak_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscili_ak_cleanup;
	return d;
}

void
oscil_aa_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscil_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	oscaa(ins);
}

void
oscil_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscil_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscil_aa";
	d->Name = "oscil_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscil_aa_activate;
	d->run = oscil_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscil_aa_cleanup;
	return d;
}

void
oscil1_i_activate(LADSPA_Handle Instance)
{
	OSCIL1 * ins = (OSCIL1 *)Instance;
	ko1set(ins);
}

void
oscil1_i_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSCIL1 * ins = (OSCIL1 *)Instance;
	set_qcs_controlrate(SampleCount);
	ko1set(ins);
}

void
oscil1_i_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscil1_i_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscil1_i";
	d->Name = "oscil1_i";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="idel";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="idur";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSCIL1_instantiate;
	d->connect_port = OSCIL1_connect_port;
	d->activate = oscil1_i_activate;
	d->run = oscil1_i_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscil1_i_cleanup;
	return d;
}

void
osciln_activate(LADSPA_Handle Instance)
{
	OSCILN * ins = (OSCILN *)Instance;
	oscnset(ins);
}

void
osciln_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSCILN * ins = (OSCILN *)Instance;
	set_qcs_controlrate(SampleCount);
	osciln(ins);
}

void
osciln_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_osciln_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "osciln";
	d->Name = "osciln";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="kamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="ifrq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="itimes";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSCILN_instantiate;
	d->connect_port = OSCILN_connect_port;
	d->activate = osciln_activate;
	d->run = osciln_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = osciln_cleanup;
	return d;
}

void
oscil_ka_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscil_ka_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	oscka(ins);
}

void
oscil_ka_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscil_ka_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscil_ka";
	d->Name = "oscil_ka";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscil_ka_activate;
	d->run = oscil_ka_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscil_ka_cleanup;
	return d;
}

void
table_i_activate(LADSPA_Handle Instance)
{
	TABLE * ins = (TABLE *)Instance;
	itable(ins);
}

void
table_i_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TABLE * ins = (TABLE *)Instance;
	set_qcs_controlrate(SampleCount);
	tblset(ins);
}

void
table_i_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_table_i_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "table_i";
	d->Name = "table_i";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ixmode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ixoff";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iwrap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TABLE_instantiate;
	d->connect_port = TABLE_connect_port;
	d->activate = table_i_activate;
	d->run = table_i_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = table_i_cleanup;
	return d;
}

void
tablekt_activate(LADSPA_Handle Instance)
{
	TABLE * ins = (TABLE *)Instance;
	tblsetkt(ins);
}

void
tablekt_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TABLE * ins = (TABLE *)Instance;
	set_qcs_controlrate(SampleCount);
	tablekt(ins);
}

void
tablekt_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tablekt_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tablekt";
	d->Name = "tablekt";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ixmode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ixoff";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iwrap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TABLE_instantiate;
	d->connect_port = TABLE_connect_port;
	d->activate = tablekt_activate;
	d->run = tablekt_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tablekt_cleanup;
	return d;
}

void
oscili_kk_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscili_kk_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	osckki(ins);
}

void
oscili_kk_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscili_kk_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscili_kk";
	d->Name = "oscili_kk";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscili_kk_activate;
	d->run = oscili_kk_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscili_kk_cleanup;
	return d;
}

void
tableikt_activate(LADSPA_Handle Instance)
{
	TABLE * ins = (TABLE *)Instance;
	tblsetkt(ins);
}

void
tableikt_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TABLE * ins = (TABLE *)Instance;
	set_qcs_controlrate(SampleCount);
	tablikt(ins);
}

void
tableikt_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tableikt_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tableikt";
	d->Name = "tableikt";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xndx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ixmode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ixoff";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iwrap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TABLE_instantiate;
	d->connect_port = TABLE_connect_port;
	d->activate = tableikt_activate;
	d->run = tableikt_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tableikt_cleanup;
	return d;
}

void
oscili_aa_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscili_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	oscaai(ins);
}

void
oscili_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscili_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscili_aa";
	d->Name = "oscili_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscili_aa_activate;
	d->run = oscili_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscili_aa_cleanup;
	return d;
}

void
oscili_ka_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscili_ka_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	osckai(ins);
}

void
oscili_ka_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscili_ka_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscili_ka";
	d->Name = "oscili_ka";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscili_ka_activate;
	d->run = oscili_ka_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscili_ka_cleanup;
	return d;
}

void
oscil_ak_activate(LADSPA_Handle Instance)
{
	OSC * ins = (OSC *)Instance;
	oscset(ins);
}

void
oscil_ak_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSC * ins = (OSC *)Instance;
	set_qcs_controlrate(SampleCount);
	oscak(ins);
}

void
oscil_ak_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscil_ak_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscil_ak";
	d->Name = "oscil_ak";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iphs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSC_instantiate;
	d->connect_port = OSC_connect_port;
	d->activate = oscil_ak_activate;
	d->run = oscil_ak_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscil_ak_cleanup;
	return d;
}

void
oscilx_activate(LADSPA_Handle Instance)
{
	OSCILN * ins = (OSCILN *)Instance;
	oscnset(ins);
}

void
oscilx_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OSCILN * ins = (OSCILN *)Instance;
	set_qcs_controlrate(SampleCount);
	osciln(ins);
}

void
oscilx_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_oscilx_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "oscilx";
	d->Name = "oscilx";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="kamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="ifrq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="itimes";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OSCILN_instantiate;
	d->connect_port = OSCILN_connect_port;
	d->activate = oscilx_activate;
	d->run = oscilx_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = oscilx_cleanup;
	return d;
}

enum descriptor_enum {
	tablei_desc_enum, oscil_kk_desc_enum, phasor_desc_enum, oscil_aa_desc_enum, oscil1_i_desc_enum, table_i_desc_enum, oscil_ka_desc_enum, oscil_ak_desc_enum, oscili_ak_desc_enum, tablekt_desc_enum, oscili_kk_desc_enum, tableikt_desc_enum, oscili_ka_desc_enum, osciln_desc_enum, oscili_aa_desc_enum, oscilx_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *tablei_desc_pointer;
	static LADSPA_Descriptor *oscil_kk_desc_pointer;
	static LADSPA_Descriptor *phasor_desc_pointer;
	static LADSPA_Descriptor *oscil_aa_desc_pointer;
	static LADSPA_Descriptor *oscil1_i_desc_pointer;
	static LADSPA_Descriptor *table_i_desc_pointer;
	static LADSPA_Descriptor *oscil_ka_desc_pointer;
	static LADSPA_Descriptor *oscil_ak_desc_pointer;
	static LADSPA_Descriptor *oscili_ak_desc_pointer;
	static LADSPA_Descriptor *tablekt_desc_pointer;
	static LADSPA_Descriptor *oscili_kk_desc_pointer;
	static LADSPA_Descriptor *tableikt_desc_pointer;
	static LADSPA_Descriptor *oscili_ka_desc_pointer;
	static LADSPA_Descriptor *osciln_desc_pointer;
	static LADSPA_Descriptor *oscili_aa_desc_pointer;
	static LADSPA_Descriptor *oscilx_desc_pointer;

	if (!inited) {
		tablei_desc_pointer = new_tablei_desc();
		oscil_kk_desc_pointer = new_oscil_kk_desc();
		phasor_desc_pointer = new_phasor_desc();
		oscil_aa_desc_pointer = new_oscil_aa_desc();
		oscil1_i_desc_pointer = new_oscil1_i_desc();
		table_i_desc_pointer = new_table_i_desc();
		oscil_ka_desc_pointer = new_oscil_ka_desc();
		oscil_ak_desc_pointer = new_oscil_ak_desc();
		oscili_ak_desc_pointer = new_oscili_ak_desc();
		tablekt_desc_pointer = new_tablekt_desc();
		oscili_kk_desc_pointer = new_oscili_kk_desc();
		tableikt_desc_pointer = new_tableikt_desc();
		oscili_ka_desc_pointer = new_oscili_ka_desc();
		osciln_desc_pointer = new_osciln_desc();
		oscili_aa_desc_pointer = new_oscili_aa_desc();
		oscilx_desc_pointer = new_oscilx_desc();

		inited=true;
	}
	
	switch(Index) {
		case tablei_desc_enum : return tablei_desc_pointer;
		case oscil_kk_desc_enum : return oscil_kk_desc_pointer;
		case phasor_desc_enum : return phasor_desc_pointer;
		case oscil_aa_desc_enum : return oscil_aa_desc_pointer;
		case oscil1_i_desc_enum : return oscil1_i_desc_pointer;
		case table_i_desc_enum : return table_i_desc_pointer;
		case oscil_ka_desc_enum : return oscil_ka_desc_pointer;
		case oscil_ak_desc_enum : return oscil_ak_desc_pointer;
		case oscili_ak_desc_enum : return oscili_ak_desc_pointer;
		case tablekt_desc_enum : return tablekt_desc_pointer;
		case oscili_kk_desc_enum : return oscili_kk_desc_pointer;
		case tableikt_desc_enum : return tableikt_desc_pointer;
		case oscili_ka_desc_enum : return oscili_ka_desc_pointer;
		case osciln_desc_enum : return osciln_desc_pointer;
		case oscili_aa_desc_enum : return oscili_aa_desc_pointer;
		case oscilx_desc_enum : return oscilx_desc_pointer;

		default:
			return 0;
	}
}
