
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens1.h"


LADSPA_Handle
ENVLPR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ENVLPR * i = new ENVLPR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ENVLPR_port_enum {
	ENVLPR_rslt_enum, ENVLPR_xamp_enum, ENVLPR_irise_enum, ENVLPR_idec_enum, ENVLPR_ifn_enum, ENVLPR_iatss_enum, ENVLPR_iatdec_enum, ENVLPR_ixmod_enum, ENVLPR_irind_enum, 
};

void
ENVLPR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ENVLPR * ins = (ENVLPR *)Instance;
	switch(Port) {

		case ENVLPR_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case ENVLPR_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case ENVLPR_irise_enum:
			ins->irise = DataLocation;
			break;

		case ENVLPR_idec_enum:
			ins->idec = DataLocation;
			break;

		case ENVLPR_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case ENVLPR_iatss_enum:
			ins->iatss = DataLocation;
			break;

		case ENVLPR_iatdec_enum:
			ins->iatdec = DataLocation;
			break;

		case ENVLPR_ixmod_enum:
			ins->ixmod = DataLocation;
			break;

		case ENVLPR_irind_enum:
			ins->irind = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
ENVLPX_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ENVLPX * i = new ENVLPX;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ENVLPX_port_enum {
	ENVLPX_rslt_enum, ENVLPX_xamp_enum, ENVLPX_irise_enum, ENVLPX_idur_enum, ENVLPX_idec_enum, ENVLPX_ifn_enum, ENVLPX_iatss_enum, ENVLPX_iatdec_enum, ENVLPX_ixmod_enum, 
};

void
ENVLPX_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ENVLPX * ins = (ENVLPX *)Instance;
	switch(Port) {

		case ENVLPX_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case ENVLPX_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case ENVLPX_irise_enum:
			ins->irise = DataLocation;
			break;

		case ENVLPX_idur_enum:
			ins->idur = DataLocation;
			break;

		case ENVLPX_idec_enum:
			ins->idec = DataLocation;
			break;

		case ENVLPX_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case ENVLPX_iatss_enum:
			ins->iatss = DataLocation;
			break;

		case ENVLPX_iatdec_enum:
			ins->iatdec = DataLocation;
			break;

		case ENVLPX_ixmod_enum:
			ins->ixmod = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
EXPON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	EXPON * i = new EXPON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum EXPON_port_enum {
	EXPON_xr_enum, EXPON_ia_enum, EXPON_idur_enum, EXPON_ib_enum, 
};

void
EXPON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	EXPON * ins = (EXPON *)Instance;
	switch(Port) {

		case EXPON_xr_enum:
			ins->xr = DataLocation;
			break;

		case EXPON_ia_enum:
			ins->ia = DataLocation;
			break;

		case EXPON_idur_enum:
			ins->idur = DataLocation;
			break;

		case EXPON_ib_enum:
			ins->ib = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LINE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LINE * i = new LINE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LINE_port_enum {
	LINE_xr_enum, LINE_ia_enum, LINE_idur_enum, LINE_ib_enum, 
};

void
LINE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LINE * ins = (LINE *)Instance;
	switch(Port) {

		case LINE_xr_enum:
			ins->xr = DataLocation;
			break;

		case LINE_ia_enum:
			ins->ia = DataLocation;
			break;

		case LINE_idur_enum:
			ins->idur = DataLocation;
			break;

		case LINE_ib_enum:
			ins->ib = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
EXPSEG2_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	EXPSEG2 * i = new EXPSEG2;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum EXPSEG2_port_enum {
	EXPSEG2_rslt_enum, EXPSEG2_argums_enum, 
};

void
EXPSEG2_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	EXPSEG2 * ins = (EXPSEG2 *)Instance;
	switch(Port) {

		case EXPSEG2_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case EXPSEG2_argums_enum:
			ins->argums = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LINENR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LINENR * i = new LINENR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LINENR_port_enum {
	LINENR_rslt_enum, LINENR_sig_enum, LINENR_iris_enum, LINENR_idec_enum, LINENR_iatdec_enum, 
};

void
LINENR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LINENR * ins = (LINENR *)Instance;
	switch(Port) {

		case LINENR_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case LINENR_sig_enum:
			ins->sig = DataLocation;
			break;

		case LINENR_iris_enum:
			ins->iris = DataLocation;
			break;

		case LINENR_idec_enum:
			ins->idec = DataLocation;
			break;

		case LINENR_iatdec_enum:
			ins->iatdec = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LINSEG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LINSEG * i = new LINSEG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LINSEG_port_enum {
	LINSEG_rslt_enum, LINSEG_argums_enum, 
};

void
LINSEG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LINSEG * ins = (LINSEG *)Instance;
	switch(Port) {

		case LINSEG_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case LINSEG_argums_enum:
			ins->argums = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
EXXPSEG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	EXXPSEG * i = new EXXPSEG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum EXXPSEG_port_enum {
	EXXPSEG_rslt_enum, EXXPSEG_argums_enum, 
};

void
EXXPSEG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	EXXPSEG * ins = (EXXPSEG *)Instance;
	switch(Port) {

		case EXXPSEG_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case EXXPSEG_argums_enum:
			ins->argums = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
EXPSEG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	EXPSEG * i = new EXPSEG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum EXPSEG_port_enum {
	EXPSEG_rslt_enum, EXPSEG_argums_enum, 
};

void
EXPSEG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	EXPSEG * ins = (EXPSEG *)Instance;
	switch(Port) {

		case EXPSEG_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case EXPSEG_argums_enum:
			ins->argums = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LINEN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LINEN * i = new LINEN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LINEN_port_enum {
	LINEN_rslt_enum, LINEN_sig_enum, LINEN_iris_enum, LINEN_idur_enum, LINEN_idec_enum, 
};

void
LINEN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LINEN * ins = (LINEN *)Instance;
	switch(Port) {

		case LINEN_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case LINEN_sig_enum:
			ins->sig = DataLocation;
			break;

		case LINEN_iris_enum:
			ins->iris = DataLocation;
			break;

		case LINEN_idur_enum:
			ins->idur = DataLocation;
			break;

		case LINEN_idec_enum:
			ins->idec = DataLocation;
			break;

		default:
			break;
	}
}

void
expon_activate(LADSPA_Handle Instance)
{
	EXPON * ins = (EXPON *)Instance;
	expset(ins);
}

void
expon_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EXPON * ins = (EXPON *)Instance;
	set_qcs_controlrate(SampleCount);
	expon(ins);
}

void
expon_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_expon_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "expon";
	d->Name = "expon";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="xr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ia";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="idur";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ib";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EXPON_instantiate;
	d->connect_port = EXPON_connect_port;
	d->activate = expon_activate;
	d->run = expon_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = expon_cleanup;
	return d;
}

void
line_activate(LADSPA_Handle Instance)
{
	LINE * ins = (LINE *)Instance;
	linset(ins);
}

void
line_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LINE * ins = (LINE *)Instance;
	set_qcs_controlrate(SampleCount);
	aline(ins);
}

void
line_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_line_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "line";
	d->Name = "line";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="xr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ia";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="idur";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ib";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LINE_instantiate;
	d->connect_port = LINE_connect_port;
	d->activate = line_activate;
	d->run = line_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = line_cleanup;
	return d;
}

void
linen_activate(LADSPA_Handle Instance)
{
	LINEN * ins = (LINEN *)Instance;
	lnnset(ins);
}

void
linen_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LINEN * ins = (LINEN *)Instance;
	set_qcs_controlrate(SampleCount);
	linen(ins);
}

void
linen_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_linen_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "linen";
	d->Name = "linen";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="sig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="iris";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="idur";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="idec";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LINEN_instantiate;
	d->connect_port = LINEN_connect_port;
	d->activate = linen_activate;
	d->run = linen_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = linen_cleanup;
	return d;
}

void
linenr_activate(LADSPA_Handle Instance)
{
	LINENR * ins = (LINENR *)Instance;
	lnrset(ins);
}

void
linenr_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LINENR * ins = (LINENR *)Instance;
	set_qcs_controlrate(SampleCount);
	linenr(ins);
}

void
linenr_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_linenr_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "linenr";
	d->Name = "linenr";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="sig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="iris";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="idec";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iatdec";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LINENR_instantiate;
	d->connect_port = LINENR_connect_port;
	d->activate = linenr_activate;
	d->run = linenr_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = linenr_cleanup;
	return d;
}

void
envlpx_activate(LADSPA_Handle Instance)
{
	ENVLPX * ins = (ENVLPX *)Instance;
	evxset(ins);
}

void
envlpx_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ENVLPX * ins = (ENVLPX *)Instance;
	set_qcs_controlrate(SampleCount);
	envlpx(ins);
}

void
envlpx_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_envlpx_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "envlpx";
	d->Name = "envlpx";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="irise";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="idur";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="idec";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="iatss";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iatdec";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ixmod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ENVLPX_instantiate;
	d->connect_port = ENVLPX_connect_port;
	d->activate = envlpx_activate;
	d->run = envlpx_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = envlpx_cleanup;
	return d;
}

enum descriptor_enum {
	envlpx_desc_enum, expon_desc_enum, line_desc_enum, linen_desc_enum, linenr_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *envlpx_desc_pointer;
	static LADSPA_Descriptor *expon_desc_pointer;
	static LADSPA_Descriptor *line_desc_pointer;
	static LADSPA_Descriptor *linen_desc_pointer;
	static LADSPA_Descriptor *linenr_desc_pointer;

	if (!inited) {
		envlpx_desc_pointer = new_envlpx_desc();
		expon_desc_pointer = new_expon_desc();
		line_desc_pointer = new_line_desc();
		linen_desc_pointer = new_linen_desc();
		linenr_desc_pointer = new_linenr_desc();

		inited=true;
	}
	
	switch(Index) {
		case envlpx_desc_enum : return envlpx_desc_pointer;
		case expon_desc_enum : return expon_desc_pointer;
		case line_desc_enum : return line_desc_pointer;
		case linen_desc_enum : return linen_desc_pointer;
		case linenr_desc_enum : return linenr_desc_pointer;

		default:
			return 0;
	}
}
