
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "timeops.h"


LADSPA_Handle
REL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	REL * i = new REL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum REL_port_enum {
	REL_r_enum, 
};

void
REL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	REL * ins = (REL *)Instance;
	switch(Port) {

		case REL_r_enum:
			ins->r = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
RDTIME_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RDTIME * i = new RDTIME;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RDTIME_port_enum {
	RDTIME_rslt_enum, 
};

void
RDTIME_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RDTIME * ins = (RDTIME *)Instance;
	switch(Port) {

		case RDTIME_rslt_enum:
			ins->rslt = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
XTRADUR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	XTRADUR * i = new XTRADUR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum XTRADUR_port_enum {
	XTRADUR_extradur_enum, 
};

void
XTRADUR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	XTRADUR * ins = (XTRADUR *)Instance;
	switch(Port) {

		case XTRADUR_extradur_enum:
			ins->extradur = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
