
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "svfilter.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
SVF_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SVF * i = new SVF;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SVF_port_enum {
	SVF_low_enum, SVF_high_enum, SVF_band_enum, SVF_in_enum, SVF_kfco_enum, SVF_kq_enum, SVF_iscl_enum, 
};

void
SVF_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SVF * ins = (SVF *)Instance;
	switch(Port) {

		case SVF_low_enum:
			ins->low = DataLocation;
			break;

		case SVF_high_enum:
			ins->high = DataLocation;
			break;

		case SVF_band_enum:
			ins->band = DataLocation;
			break;

		case SVF_in_enum:
			ins->in = DataLocation;
			break;

		case SVF_kfco_enum:
			ins->kfco = DataLocation;
			break;

		case SVF_kq_enum:
			ins->kq = DataLocation;
			break;

		case SVF_iscl_enum:
			ins->iscl = DataLocation;
			break;

		default:
			break;
	}
}

void
svfilter_activate(LADSPA_Handle Instance)
{
	SVF * ins = (SVF *)Instance;
	svfset(ins);
}

void
svfilter_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SVF * ins = (SVF *)Instance;
	set_qcs_controlrate(SampleCount);
	svf(ins);
}

void
svfilter_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_svfilter_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "svfilter";
	d->Name = "svfilter";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="low";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="high";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="band";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SVF_instantiate;
	d->connect_port = SVF_connect_port;
	d->activate = svfilter_activate;
	d->run = svfilter_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = svfilter_cleanup;
	return d;
}

enum descriptor_enum {
	svfilter_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *svfilter_desc_pointer;

	if (!inited) {
		svfilter_desc_pointer = new_svfilter_desc();

		inited=true;
	}
	
	switch(Index) {
		case svfilter_desc_enum : return svfilter_desc_pointer;

		default:
			return 0;
	}
}
