
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "streson.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
STRES_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	STRES * i = new STRES;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum STRES_port_enum {
	STRES_result_enum, STRES_ainput_enum, STRES_afr_enum, STRES_ifdbgain_enum, STRES_Cdelay_enum, 
};

void
STRES_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	STRES * ins = (STRES *)Instance;
	switch(Port) {

		case STRES_result_enum:
			ins->result = DataLocation;
			break;

		case STRES_ainput_enum:
			ins->ainput = DataLocation;
			break;

		case STRES_afr_enum:
			ins->afr = DataLocation;
			break;

		case STRES_ifdbgain_enum:
			ins->ifdbgain = DataLocation;
			break;

		case STRES_Cdelay_enum:
			ins->Cdelay = DataLocation;
			break;

		default:
			break;
	}
}

void
streson_activate(LADSPA_Handle Instance)
{
	STRES * ins = (STRES *)Instance;
	stresonset(ins);
}

void
streson_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	STRES * ins = (STRES *)Instance;
	set_qcs_controlrate(SampleCount);
	streson(ins);
}

void
streson_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_streson_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "streson";
	d->Name = "streson";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="result";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ainput";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="afr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ifdbgain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = STRES_instantiate;
	d->connect_port = STRES_connect_port;
	d->activate = streson_activate;
	d->run = streson_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = streson_cleanup;
	return d;
}

enum descriptor_enum {
	streson_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *streson_desc_pointer;

	if (!inited) {
		streson_desc_pointer = new_streson_desc();

		inited=true;
	}
	
	switch(Index) {
		case streson_desc_enum : return streson_desc_pointer;

		default:
			return 0;
	}
}
