
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "singwave.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
VOICF_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	VOICF * i = new VOICF;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum VOICF_port_enum {
	VOICF_ar_enum, VOICF_amp_enum, VOICF_frequency_enum, VOICF_phoneme_enum, VOICF_formant_enum, VOICF_vibf_enum, VOICF_vibAmt_enum, VOICF_ifn_enum, VOICF_ivfn_enum, 
};

void
VOICF_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	VOICF * ins = (VOICF *)Instance;
	switch(Port) {

		case VOICF_ar_enum:
			ins->ar = DataLocation;
			break;

		case VOICF_amp_enum:
			ins->amp = DataLocation;
			break;

		case VOICF_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case VOICF_phoneme_enum:
			ins->phoneme = DataLocation;
			break;

		case VOICF_formant_enum:
			ins->formant = DataLocation;
			break;

		case VOICF_vibf_enum:
			ins->vibf = DataLocation;
			break;

		case VOICF_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case VOICF_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case VOICF_ivfn_enum:
			ins->ivfn = DataLocation;
			break;

		default:
			break;
	}
}

void
voice_activate(LADSPA_Handle Instance)
{
	VOICF * ins = (VOICF *)Instance;
	voicformset(ins);
}

void
voice_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	VOICF * ins = (VOICF *)Instance;
	set_qcs_controlrate(SampleCount);
	voicform(ins);
}

void
voice_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_voice_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "voice";
	d->Name = "voice";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="phoneme";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="formant";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="vibf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ivfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = VOICF_instantiate;
	d->connect_port = VOICF_connect_port;
	d->activate = voice_activate;
	d->run = voice_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = voice_cleanup;
	return d;
}

enum descriptor_enum {
	voice_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *voice_desc_pointer;

	if (!inited) {
		voice_desc_pointer = new_voice_desc();

		inited=true;
	}
	
	switch(Index) {
		case voice_desc_enum : return voice_desc_pointer;

		default:
			return 0;
	}
}
