
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "sendsig.h"


LADSPA_Handle
SENDSIG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SENDSIG * i = new SENDSIG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SENDSIG_port_enum {
	SENDSIG_source_enum, SENDSIG_sinkname_enum, 
};

void
SENDSIG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SENDSIG * ins = (SENDSIG *)Instance;
	switch(Port) {

		case SENDSIG_source_enum:
			ins->source = DataLocation;
			break;

		case SENDSIG_sinkname_enum:
			ins->sinkname = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
sendsig_activate(LADSPA_Handle Instance)
{
	SENDSIG * ins = (SENDSIG *)Instance;
	sendsiginit(ins);
}

void
sendsig_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SENDSIG * ins = (SENDSIG *)Instance;
	set_qcs_controlrate(SampleCount);
	sendsig(ins);
}

void
sendsig_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sendsig_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sendsig";
	d->Name = "sendsig";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="source";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="sinkname";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SENDSIG_instantiate;
	d->connect_port = SENDSIG_connect_port;
	d->activate = sendsig_activate;
	d->run = sendsig_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sendsig_cleanup;
	return d;
}

enum descriptor_enum {
	sendsig_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *sendsig_desc_pointer;

	if (!inited) {
		sendsig_desc_pointer = new_sendsig_desc();

		inited=true;
	}
	
	switch(Index) {
		case sendsig_desc_enum : return sendsig_desc_pointer;

		default:
			return 0;
	}
}
