
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "rtsin.h"


LADSPA_Handle
RTSIN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RTSIN * i = new RTSIN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RTSIN_port_enum {
	RTSIN_ar_enum, RTSIN_freq_enum, RTSIN_amp_enum, 
};

void
RTSIN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RTSIN * ins = (RTSIN *)Instance;
	switch(Port) {

		case RTSIN_ar_enum:
			ins->ar = DataLocation;
			break;

		case RTSIN_freq_enum:
			ins->freq = DataLocation;
			break;

		case RTSIN_amp_enum:
			ins->amp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
rtsin_activate(LADSPA_Handle Instance)
{
	RTSIN * ins = (RTSIN *)Instance;
	rtsinset(ins);
}

void
rtsin_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RTSIN * ins = (RTSIN *)Instance;
	set_qcs_controlrate(SampleCount);
	rtsina(ins);
}

void
rtsin_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_rtsin_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "rtsin";
	d->Name = "rtsin";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="freq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RTSIN_instantiate;
	d->connect_port = RTSIN_connect_port;
	d->activate = rtsin_activate;
	d->run = rtsin_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = rtsin_cleanup;
	return d;
}

void
rtsinfm_activate(LADSPA_Handle Instance)
{
	RTSIN * ins = (RTSIN *)Instance;
	rtsinset(ins);
}

void
rtsinfm_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RTSIN * ins = (RTSIN *)Instance;
	set_qcs_controlrate(SampleCount);
	rtsin_fm_audio(ins);
}

void
rtsinfm_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_rtsinfm_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "rtsinfm";
	d->Name = "rtsinfm";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="freq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RTSIN_instantiate;
	d->connect_port = RTSIN_connect_port;
	d->activate = rtsinfm_activate;
	d->run = rtsinfm_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = rtsinfm_cleanup;
	return d;
}

enum descriptor_enum {
	rtsin_desc_enum, rtsinfm_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *rtsin_desc_pointer;
	static LADSPA_Descriptor *rtsinfm_desc_pointer;

	if (!inited) {
		rtsin_desc_pointer = new_rtsin_desc();
		rtsinfm_desc_pointer = new_rtsinfm_desc();

		inited=true;
	}
	
	switch(Index) {
		case rtsin_desc_enum : return rtsin_desc_pointer;
		case rtsinfm_desc_enum : return rtsinfm_desc_pointer;

		default:
			return 0;
	}
}
