
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "resonz.h"


LADSPA_Handle
RESONZ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RESONZ * i = new RESONZ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RESONZ_port_enum {
	RESONZ_out_enum, RESONZ_in_enum, RESONZ_kcf_enum, RESONZ_kbw_enum, RESONZ_iscl_enum, RESONZ_istor_enum, 
};

void
RESONZ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RESONZ * ins = (RESONZ *)Instance;
	switch(Port) {

		case RESONZ_out_enum:
			ins->out = DataLocation;
			break;

		case RESONZ_in_enum:
			ins->in = DataLocation;
			break;

		case RESONZ_kcf_enum:
			ins->kcf = DataLocation;
			break;

		case RESONZ_kbw_enum:
			ins->kbw = DataLocation;
			break;

		case RESONZ_iscl_enum:
			ins->iscl = DataLocation;
			break;

		case RESONZ_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
resonr_activate(LADSPA_Handle Instance)
{
	RESONZ * ins = (RESONZ *)Instance;
	resonzset(ins);
}

void
resonr_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RESONZ * ins = (RESONZ *)Instance;
	set_qcs_controlrate(SampleCount);
	resonr(ins);
}

void
resonr_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_resonr_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "resonr";
	d->Name = "resonr";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RESONZ_instantiate;
	d->connect_port = RESONZ_connect_port;
	d->activate = resonr_activate;
	d->run = resonr_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = resonr_cleanup;
	return d;
}

void
resonz_activate(LADSPA_Handle Instance)
{
	RESONZ * ins = (RESONZ *)Instance;
	resonzset(ins);
}

void
resonz_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	RESONZ * ins = (RESONZ *)Instance;
	set_qcs_controlrate(SampleCount);
	resonz(ins);
}

void
resonz_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_resonz_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "resonz";
	d->Name = "resonz";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kcf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="iscl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = RESONZ_instantiate;
	d->connect_port = RESONZ_connect_port;
	d->activate = resonz_activate;
	d->run = resonz_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = resonz_cleanup;
	return d;
}

enum descriptor_enum {
	resonr_desc_enum, resonz_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *resonr_desc_pointer;
	static LADSPA_Descriptor *resonz_desc_pointer;

	if (!inited) {
		resonr_desc_pointer = new_resonr_desc();
		resonz_desc_pointer = new_resonz_desc();

		inited=true;
	}
	
	switch(Index) {
		case resonr_desc_enum : return resonr_desc_pointer;
		case resonz_desc_enum : return resonz_desc_pointer;

		default:
			return 0;
	}
}
