
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "mathops.h"


LADSPA_Handle
POW_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	POW * i = new POW;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum POW_port_enum {
	POW_sr_enum, POW_in_enum, POW_pow_enum, POW_norm_enum, 
};

void
POW_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	POW * ins = (POW *)Instance;
	switch(Port) {

		case POW_sr_enum:
			ins->sr = DataLocation;
			break;

		case POW_in_enum:
			ins->in = DataLocation;
			break;

		case POW_pow_enum:
			ins->pow = DataLocation;
			break;

		case POW_norm_enum:
			ins->norm = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
PRAND_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PRAND * i = new PRAND;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PRAND_port_enum {
	PRAND_out_enum, PRAND_arg1_enum, PRAND_arg2_enum, PRAND_arg3_enum, 
};

void
PRAND_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PRAND * ins = (PRAND *)Instance;
	switch(Port) {

		case PRAND_out_enum:
			ins->out = DataLocation;
			break;

		case PRAND_arg1_enum:
			ins->arg1 = DataLocation;
			break;

		case PRAND_arg2_enum:
			ins->arg2 = DataLocation;
			break;

		case PRAND_arg3_enum:
			ins->arg3 = DataLocation;
			break;

		default:
			break;
	}
}

void
gauss_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	agaus(ins);
}

void
gauss_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gauss_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gauss_a";
	d->Name = "gauss_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = gauss_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gauss_a_cleanup;
	return d;
}

void
pcauchy_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	apcauchy(ins);
}

void
pcauchy_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pcauchy_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pcauchy_a";
	d->Name = "pcauchy_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = pcauchy_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pcauchy_a_cleanup;
	return d;
}

void
unirand_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	auniform(ins);
}

void
unirand_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_unirand_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "unirand_a";
	d->Name = "unirand_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = unirand_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = unirand_a_cleanup;
	return d;
}

void
linrand_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	alinear(ins);
}

void
linrand_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_linrand_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "linrand_a";
	d->Name = "linrand_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = linrand_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = linrand_a_cleanup;
	return d;
}

void
cauchy_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	acauchy(ins);
}

void
cauchy_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cauchy_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cauchy_a";
	d->Name = "cauchy_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = cauchy_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cauchy_a_cleanup;
	return d;
}

void
trirand_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	atrian(ins);
}

void
trirand_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_trirand_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "trirand_a";
	d->Name = "trirand_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = trirand_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = trirand_a_cleanup;
	return d;
}

void
betarand_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	abeta(ins);
}

void
betarand_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_betarand_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "betarand_a";
	d->Name = "betarand_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="arg2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="arg3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = betarand_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = betarand_a_cleanup;
	return d;
}

void
weibull_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	aweib(ins);
}

void
weibull_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_weibull_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "weibull_a";
	d->Name = "weibull_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="arg2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = weibull_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = weibull_a_cleanup;
	return d;
}

void
bexprnd_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	abiexp(ins);
}

void
bexprnd_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_bexprnd_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "bexprnd_a";
	d->Name = "bexprnd_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = bexprnd_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = bexprnd_a_cleanup;
	return d;
}

void
poisson_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	apoiss(ins);
}

void
poisson_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_poisson_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "poisson_a";
	d->Name = "poisson_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = poisson_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = poisson_a_cleanup;
	return d;
}

void
pow_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	POW * ins = (POW *)Instance;
	set_qcs_controlrate(SampleCount);
	apow(ins);
}

void
pow_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pow_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pow_a";
	d->Name = "pow_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="pow";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="norm";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = POW_instantiate;
	d->connect_port = POW_connect_port;
	d->activate = 0;
	d->run = pow_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pow_a_cleanup;
	return d;
}

void
exprand_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PRAND * ins = (PRAND *)Instance;
	set_qcs_controlrate(SampleCount);
	aexp(ins);
}

void
exprand_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_exprand_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "exprand_a";
	d->Name = "exprand_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="arg1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PRAND_instantiate;
	d->connect_port = PRAND_connect_port;
	d->activate = 0;
	d->run = exprand_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = exprand_a_cleanup;
	return d;
}

enum descriptor_enum {
	gauss_a_desc_enum, betarand_a_desc_enum, pcauchy_a_desc_enum, weibull_a_desc_enum, bexprnd_a_desc_enum, trirand_a_desc_enum, poisson_a_desc_enum, cauchy_a_desc_enum, pow_a_desc_enum, unirand_a_desc_enum, exprand_a_desc_enum, linrand_a_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *gauss_a_desc_pointer;
	static LADSPA_Descriptor *betarand_a_desc_pointer;
	static LADSPA_Descriptor *pcauchy_a_desc_pointer;
	static LADSPA_Descriptor *weibull_a_desc_pointer;
	static LADSPA_Descriptor *bexprnd_a_desc_pointer;
	static LADSPA_Descriptor *trirand_a_desc_pointer;
	static LADSPA_Descriptor *poisson_a_desc_pointer;
	static LADSPA_Descriptor *cauchy_a_desc_pointer;
	static LADSPA_Descriptor *pow_a_desc_pointer;
	static LADSPA_Descriptor *unirand_a_desc_pointer;
	static LADSPA_Descriptor *exprand_a_desc_pointer;
	static LADSPA_Descriptor *linrand_a_desc_pointer;

	if (!inited) {
		gauss_a_desc_pointer = new_gauss_a_desc();
		betarand_a_desc_pointer = new_betarand_a_desc();
		pcauchy_a_desc_pointer = new_pcauchy_a_desc();
		weibull_a_desc_pointer = new_weibull_a_desc();
		bexprnd_a_desc_pointer = new_bexprnd_a_desc();
		trirand_a_desc_pointer = new_trirand_a_desc();
		poisson_a_desc_pointer = new_poisson_a_desc();
		cauchy_a_desc_pointer = new_cauchy_a_desc();
		pow_a_desc_pointer = new_pow_a_desc();
		unirand_a_desc_pointer = new_unirand_a_desc();
		exprand_a_desc_pointer = new_exprand_a_desc();
		linrand_a_desc_pointer = new_linrand_a_desc();

		inited=true;
	}
	
	switch(Index) {
		case gauss_a_desc_enum : return gauss_a_desc_pointer;
		case betarand_a_desc_enum : return betarand_a_desc_pointer;
		case pcauchy_a_desc_enum : return pcauchy_a_desc_pointer;
		case weibull_a_desc_enum : return weibull_a_desc_pointer;
		case bexprnd_a_desc_enum : return bexprnd_a_desc_pointer;
		case trirand_a_desc_enum : return trirand_a_desc_pointer;
		case poisson_a_desc_enum : return poisson_a_desc_pointer;
		case cauchy_a_desc_enum : return cauchy_a_desc_pointer;
		case pow_a_desc_enum : return pow_a_desc_pointer;
		case unirand_a_desc_enum : return unirand_a_desc_pointer;
		case exprand_a_desc_enum : return exprand_a_desc_pointer;
		case linrand_a_desc_enum : return linrand_a_desc_pointer;

		default:
			return 0;
	}
}
