
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "marimba.h"


LADSPA_Handle
MARIMBA_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MARIMBA * i = new MARIMBA;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MARIMBA_port_enum {
	MARIMBA_ar_enum, MARIMBA_amplitude_enum, MARIMBA_frequency_enum, MARIMBA_hardness_enum, MARIMBA_spos_enum, MARIMBA_ifn_enum, MARIMBA_vibFreq_enum, MARIMBA_vibAmt_enum, MARIMBA_ivfn_enum, MARIMBA_dettack_enum, 
};

void
MARIMBA_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MARIMBA * ins = (MARIMBA *)Instance;
	switch(Port) {

		case MARIMBA_ar_enum:
			ins->ar = DataLocation;
			break;

		case MARIMBA_amplitude_enum:
			ins->amplitude = DataLocation;
			break;

		case MARIMBA_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case MARIMBA_hardness_enum:
			ins->hardness = DataLocation;
			break;

		case MARIMBA_spos_enum:
			ins->spos = DataLocation;
			break;

		case MARIMBA_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case MARIMBA_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case MARIMBA_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case MARIMBA_ivfn_enum:
			ins->ivfn = DataLocation;
			break;

		case MARIMBA_dettack_enum:
			ins->dettack = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
marimba_activate(LADSPA_Handle Instance)
{
	MARIMBA * ins = (MARIMBA *)Instance;
	marimbaset(ins);
}

void
marimba_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	MARIMBA * ins = (MARIMBA *)Instance;
	set_qcs_controlrate(SampleCount);
	marimba(ins);
}

void
marimba_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_marimba_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "marimba";
	d->Name = "marimba";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 10;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amplitude";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="hardness";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="spos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ivfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = MARIMBA_instantiate;
	d->connect_port = MARIMBA_connect_port;
	d->activate = marimba_activate;
	d->run = marimba_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = marimba_cleanup;
	return d;
}

enum descriptor_enum {
	marimba_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *marimba_desc_pointer;

	if (!inited) {
		marimba_desc_pointer = new_marimba_desc();

		inited=true;
	}
	
	switch(Index) {
		case marimba_desc_enum : return marimba_desc_pointer;

		default:
			return 0;
	}
}
