
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "lowpassr.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
LOWPRX_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LOWPRX * i = new LOWPRX;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LOWPRX_port_enum {
	LOWPRX_ar_enum, LOWPRX_asig_enum, LOWPRX_kfco_enum, LOWPRX_kres_enum, LOWPRX_ord_enum, LOWPRX_istor_enum, 
};

void
LOWPRX_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LOWPRX * ins = (LOWPRX *)Instance;
	switch(Port) {

		case LOWPRX_ar_enum:
			ins->ar = DataLocation;
			break;

		case LOWPRX_asig_enum:
			ins->asig = DataLocation;
			break;

		case LOWPRX_kfco_enum:
			ins->kfco = DataLocation;
			break;

		case LOWPRX_kres_enum:
			ins->kres = DataLocation;
			break;

		case LOWPRX_ord_enum:
			ins->ord = DataLocation;
			break;

		case LOWPRX_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LOWPR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LOWPR * i = new LOWPR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LOWPR_port_enum {
	LOWPR_ar_enum, LOWPR_asig_enum, LOWPR_kfco_enum, LOWPR_kres_enum, LOWPR_istor_enum, 
};

void
LOWPR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LOWPR * ins = (LOWPR *)Instance;
	switch(Port) {

		case LOWPR_ar_enum:
			ins->ar = DataLocation;
			break;

		case LOWPR_asig_enum:
			ins->asig = DataLocation;
			break;

		case LOWPR_kfco_enum:
			ins->kfco = DataLocation;
			break;

		case LOWPR_kres_enum:
			ins->kres = DataLocation;
			break;

		case LOWPR_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LOWPR_SEP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LOWPR_SEP * i = new LOWPR_SEP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LOWPR_SEP_port_enum {
	LOWPR_SEP_ar_enum, LOWPR_SEP_asig_enum, LOWPR_SEP_kfco_enum, LOWPR_SEP_kres_enum, LOWPR_SEP_ord_enum, LOWPR_SEP_sep_enum, 
};

void
LOWPR_SEP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LOWPR_SEP * ins = (LOWPR_SEP *)Instance;
	switch(Port) {

		case LOWPR_SEP_ar_enum:
			ins->ar = DataLocation;
			break;

		case LOWPR_SEP_asig_enum:
			ins->asig = DataLocation;
			break;

		case LOWPR_SEP_kfco_enum:
			ins->kfco = DataLocation;
			break;

		case LOWPR_SEP_kres_enum:
			ins->kres = DataLocation;
			break;

		case LOWPR_SEP_ord_enum:
			ins->ord = DataLocation;
			break;

		case LOWPR_SEP_sep_enum:
			ins->sep = DataLocation;
			break;

		default:
			break;
	}
}

void
lpres_activate(LADSPA_Handle Instance)
{
	LOWPR * ins = (LOWPR *)Instance;
	lowpr_set(ins);
}

void
lpres_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOWPR * ins = (LOWPR *)Instance;
	set_qcs_controlrate(SampleCount);
	lowpr(ins);
}

void
lpres_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lpres_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lpres";
	d->Name = "lpres";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kres";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOWPR_instantiate;
	d->connect_port = LOWPR_connect_port;
	d->activate = lpres_activate;
	d->run = lpres_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lpres_cleanup;
	return d;
}

void
vlowres_activate(LADSPA_Handle Instance)
{
	LOWPR_SEP * ins = (LOWPR_SEP *)Instance;
	lowpr_w_sep_set(ins);
}

void
vlowres_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOWPR_SEP * ins = (LOWPR_SEP *)Instance;
	set_qcs_controlrate(SampleCount);
	lowpr_w_sep(ins);
}

void
vlowres_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_vlowres_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "vlowres";
	d->Name = "vlowres";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kres";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="sep";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOWPR_SEP_instantiate;
	d->connect_port = LOWPR_SEP_connect_port;
	d->activate = vlowres_activate;
	d->run = vlowres_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = vlowres_cleanup;
	return d;
}

void
lpresx_activate(LADSPA_Handle Instance)
{
	LOWPRX * ins = (LOWPRX *)Instance;
	lowpr_setx(ins);
}

void
lpresx_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOWPRX * ins = (LOWPRX *)Instance;
	set_qcs_controlrate(SampleCount);
	lowprx(ins);
}

void
lpresx_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lpresx_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lpresx";
	d->Name = "lpresx";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kres";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOWPRX_instantiate;
	d->connect_port = LOWPRX_connect_port;
	d->activate = lpresx_activate;
	d->run = lpresx_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lpresx_cleanup;
	return d;
}

void
lowresx_activate(LADSPA_Handle Instance)
{
	LOWPRX * ins = (LOWPRX *)Instance;
	lowpr_setx(ins);
}

void
lowresx_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOWPRX * ins = (LOWPRX *)Instance;
	set_qcs_controlrate(SampleCount);
	lowprx(ins);
}

void
lowresx_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lowresx_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lowresx";
	d->Name = "lowresx";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kres";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ord";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOWPRX_instantiate;
	d->connect_port = LOWPRX_connect_port;
	d->activate = lowresx_activate;
	d->run = lowresx_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lowresx_cleanup;
	return d;
}

void
lowres_activate(LADSPA_Handle Instance)
{
	LOWPR * ins = (LOWPR *)Instance;
	lowpr_set(ins);
}

void
lowres_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LOWPR * ins = (LOWPR *)Instance;
	set_qcs_controlrate(SampleCount);
	lowpr(ins);
}

void
lowres_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lowres_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lowres";
	d->Name = "lowres";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kres";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LOWPR_instantiate;
	d->connect_port = LOWPR_connect_port;
	d->activate = lowres_activate;
	d->run = lowres_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lowres_cleanup;
	return d;
}

enum descriptor_enum {
	lowresx_desc_enum, vlowres_desc_enum, lpresx_desc_enum, lpres_desc_enum, lowres_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *lowresx_desc_pointer;
	static LADSPA_Descriptor *vlowres_desc_pointer;
	static LADSPA_Descriptor *lpresx_desc_pointer;
	static LADSPA_Descriptor *lpres_desc_pointer;
	static LADSPA_Descriptor *lowres_desc_pointer;

	if (!inited) {
		lowresx_desc_pointer = new_lowresx_desc();
		vlowres_desc_pointer = new_vlowres_desc();
		lpresx_desc_pointer = new_lpresx_desc();
		lpres_desc_pointer = new_lpres_desc();
		lowres_desc_pointer = new_lowres_desc();

		inited=true;
	}
	
	switch(Index) {
		case lowresx_desc_enum : return lowresx_desc_pointer;
		case vlowres_desc_enum : return vlowres_desc_pointer;
		case lpresx_desc_enum : return lpresx_desc_pointer;
		case lpres_desc_enum : return lpres_desc_pointer;
		case lowres_desc_enum : return lowres_desc_pointer;

		default:
			return 0;
	}
}
