
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "internal_opcodes.h"


LADSPA_Handle
VOICELIMIT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	VOICELIMIT * i = new VOICELIMIT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum VOICELIMIT_port_enum {
	VOICELIMIT_n_enum, 
};

void
VOICELIMIT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	VOICELIMIT * ins = (VOICELIMIT *)Instance;
	switch(Port) {

		case VOICELIMIT_n_enum:
			ins->n = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
PATCHPTR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PATCHPTR * i = new PATCHPTR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PATCHPTR_port_enum {
	PATCHPTR_result_enum, PATCHPTR_ptr_enum, 
};

void
PATCHPTR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PATCHPTR * ins = (PATCHPTR *)Instance;
	switch(Port) {

		case PATCHPTR_result_enum:
			ins->result = DataLocation;
			break;

		case PATCHPTR_ptr_enum:
			ins->ptr = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
