
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "hilbert.h"


LADSPA_Handle
HILBERT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	HILBERT * i = new HILBERT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum HILBERT_port_enum {
	HILBERT_out1_enum, HILBERT_out2_enum, HILBERT_in_enum, 
};

void
HILBERT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	HILBERT * ins = (HILBERT *)Instance;
	switch(Port) {

		case HILBERT_out1_enum:
			ins->out1 = DataLocation;
			break;

		case HILBERT_out2_enum:
			ins->out2 = DataLocation;
			break;

		case HILBERT_in_enum:
			ins->in = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
hilbert_activate(LADSPA_Handle Instance)
{
	HILBERT * ins = (HILBERT *)Instance;
	hilbertset(ins);
}

void
hilbert_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	HILBERT * ins = (HILBERT *)Instance;
	set_qcs_controlrate(SampleCount);
	hilbert(ins);
}

void
hilbert_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_hilbert_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "hilbert";
	d->Name = "hilbert";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="out2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = HILBERT_instantiate;
	d->connect_port = HILBERT_connect_port;
	d->activate = hilbert_activate;
	d->run = hilbert_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = hilbert_cleanup;
	return d;
}

enum descriptor_enum {
	hilbert_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *hilbert_desc_pointer;

	if (!inited) {
		hilbert_desc_pointer = new_hilbert_desc();

		inited=true;
	}
	
	switch(Index) {
		case hilbert_desc_enum : return hilbert_desc_pointer;

		default:
			return 0;
	}
}
