
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "gaver.h"


LADSPA_Handle
GAVER_SCRAPE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	GAVER_SCRAPE * i = new GAVER_SCRAPE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum GAVER_SCRAPE_port_enum {
	GAVER_SCRAPE_out_enum, GAVER_SCRAPE_speed_enum, GAVER_SCRAPE_roughness_enum, GAVER_SCRAPE_amp_enum, 
};

void
GAVER_SCRAPE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	GAVER_SCRAPE * ins = (GAVER_SCRAPE *)Instance;
	switch(Port) {

		case GAVER_SCRAPE_out_enum:
			ins->out = DataLocation;
			break;

		case GAVER_SCRAPE_speed_enum:
			ins->speed = DataLocation;
			break;

		case GAVER_SCRAPE_roughness_enum:
			ins->roughness = DataLocation;
			break;

		case GAVER_SCRAPE_amp_enum:
			ins->amp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
GAVER_IMPACT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	GAVER_IMPACT * i = new GAVER_IMPACT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum GAVER_IMPACT_port_enum {
	GAVER_IMPACT_out_enum, GAVER_IMPACT_hardness_enum, GAVER_IMPACT_amp_enum, 
};

void
GAVER_IMPACT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	GAVER_IMPACT * ins = (GAVER_IMPACT *)Instance;
	switch(Port) {

		case GAVER_IMPACT_out_enum:
			ins->out = DataLocation;
			break;

		case GAVER_IMPACT_hardness_enum:
			ins->hardness = DataLocation;
			break;

		case GAVER_IMPACT_amp_enum:
			ins->amp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
GAVER_FILTER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	GAVER_FILTER * i = new GAVER_FILTER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum GAVER_FILTER_port_enum {
	GAVER_FILTER_out_enum, GAVER_FILTER_in_enum, GAVER_FILTER_size_enum, GAVER_FILTER_shape_enum, GAVER_FILTER_material_enum, 
};

void
GAVER_FILTER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	GAVER_FILTER * ins = (GAVER_FILTER *)Instance;
	switch(Port) {

		case GAVER_FILTER_out_enum:
			ins->out = DataLocation;
			break;

		case GAVER_FILTER_in_enum:
			ins->in = DataLocation;
			break;

		case GAVER_FILTER_size_enum:
			ins->size = DataLocation;
			break;

		case GAVER_FILTER_shape_enum:
			ins->shape = DataLocation;
			break;

		case GAVER_FILTER_material_enum:
			ins->material = DataLocation;
			break;

		default:
			break;
	}
}

void
gaverimpact_activate(LADSPA_Handle Instance)
{
	GAVER_IMPACT * ins = (GAVER_IMPACT *)Instance;
	gaver_impact_set(ins);
}

void
gaverimpact_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	GAVER_IMPACT * ins = (GAVER_IMPACT *)Instance;
	set_qcs_controlrate(SampleCount);
	gaver_impact_audio(ins);
}

void
gaverimpact_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gaverimpact_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gaverimpact";
	d->Name = "gaverimpact";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="hardness";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = GAVER_IMPACT_instantiate;
	d->connect_port = GAVER_IMPACT_connect_port;
	d->activate = gaverimpact_activate;
	d->run = gaverimpact_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gaverimpact_cleanup;
	return d;
}

void
gaverfilter_activate(LADSPA_Handle Instance)
{
	GAVER_FILTER * ins = (GAVER_FILTER *)Instance;
	gaver_filter_set(ins);
}

void
gaverfilter_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	GAVER_FILTER * ins = (GAVER_FILTER *)Instance;
	set_qcs_controlrate(SampleCount);
	gaver_filter_audio(ins);
}

void
gaverfilter_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gaverfilter_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gaverfilter";
	d->Name = "gaverfilter";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="size";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="shape";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="material";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = GAVER_FILTER_instantiate;
	d->connect_port = GAVER_FILTER_connect_port;
	d->activate = gaverfilter_activate;
	d->run = gaverfilter_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gaverfilter_cleanup;
	return d;
}

void
gaverscrape_activate(LADSPA_Handle Instance)
{
	GAVER_SCRAPE * ins = (GAVER_SCRAPE *)Instance;
	gaver_scrape_set(ins);
}

void
gaverscrape_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	GAVER_SCRAPE * ins = (GAVER_SCRAPE *)Instance;
	set_qcs_controlrate(SampleCount);
	gaver_scrape_audio(ins);
}

void
gaverscrape_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_gaverscrape_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "gaverscrape";
	d->Name = "gaverscrape";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="speed";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="roughness";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = GAVER_SCRAPE_instantiate;
	d->connect_port = GAVER_SCRAPE_connect_port;
	d->activate = gaverscrape_activate;
	d->run = gaverscrape_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = gaverscrape_cleanup;
	return d;
}

enum descriptor_enum {
	gaverfilter_desc_enum, gaverimpact_desc_enum, gaverscrape_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *gaverfilter_desc_pointer;
	static LADSPA_Descriptor *gaverimpact_desc_pointer;
	static LADSPA_Descriptor *gaverscrape_desc_pointer;

	if (!inited) {
		gaverfilter_desc_pointer = new_gaverfilter_desc();
		gaverimpact_desc_pointer = new_gaverimpact_desc();
		gaverscrape_desc_pointer = new_gaverscrape_desc();

		inited=true;
	}
	
	switch(Index) {
		case gaverfilter_desc_enum : return gaverfilter_desc_pointer;
		case gaverimpact_desc_enum : return gaverimpact_desc_pointer;
		case gaverscrape_desc_enum : return gaverscrape_desc_pointer;

		default:
			return 0;
	}
}
