
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "cross2.h"


LADSPA_Handle
CON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CON * i = new CON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CON_port_enum {
	CON_out_enum, CON_as_enum, CON_af_enum, CON_len_enum, CON_ovlp_enum, CON_iwin_enum, CON_bias_enum, 
};

void
CON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CON * ins = (CON *)Instance;
	switch(Port) {

		case CON_out_enum:
			ins->out = DataLocation;
			break;

		case CON_as_enum:
			ins->as = DataLocation;
			break;

		case CON_af_enum:
			ins->af = DataLocation;
			break;

		case CON_len_enum:
			ins->len = DataLocation;
			break;

		case CON_ovlp_enum:
			ins->ovlp = DataLocation;
			break;

		case CON_iwin_enum:
			ins->iwin = DataLocation;
			break;

		case CON_bias_enum:
			ins->bias = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
cross2_activate(LADSPA_Handle Instance)
{
	CON * ins = (CON *)Instance;
	Xsynthset(ins);
}

void
cross2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	CON * ins = (CON *)Instance;
	set_qcs_controlrate(SampleCount);
	Xsynth(ins);
}

void
cross2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cross2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cross2";
	d->Name = "cross2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="as";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="af";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="len";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="ovlp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="iwin";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="bias";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = CON_instantiate;
	d->connect_port = CON_connect_port;
	d->activate = cross2_activate;
	d->run = cross2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cross2_cleanup;
	return d;
}

enum descriptor_enum {
	cross2_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *cross2_desc_pointer;

	if (!inited) {
		cross2_desc_pointer = new_cross2_desc();

		inited=true;
	}
	
	switch(Index) {
		case cross2_desc_enum : return cross2_desc_pointer;

		default:
			return 0;
	}
}
