
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "clarinet.h"


LADSPA_Handle
CLARIN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CLARIN * i = new CLARIN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CLARIN_port_enum {
	CLARIN_ar_enum, CLARIN_amp_enum, CLARIN_frequency_enum, CLARIN_reedStffns_enum, CLARIN_attack_enum, CLARIN_dettack_enum, CLARIN_noiseGain_enum, CLARIN_vibFreq_enum, CLARIN_vibAmt_enum, CLARIN_ifn_enum, CLARIN_lowestFreq_enum, 
};

void
CLARIN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CLARIN * ins = (CLARIN *)Instance;
	switch(Port) {

		case CLARIN_ar_enum:
			ins->ar = DataLocation;
			break;

		case CLARIN_amp_enum:
			ins->amp = DataLocation;
			break;

		case CLARIN_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case CLARIN_reedStffns_enum:
			ins->reedStffns = DataLocation;
			break;

		case CLARIN_attack_enum:
			ins->attack = DataLocation;
			break;

		case CLARIN_dettack_enum:
			ins->dettack = DataLocation;
			break;

		case CLARIN_noiseGain_enum:
			ins->noiseGain = DataLocation;
			break;

		case CLARIN_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case CLARIN_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case CLARIN_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case CLARIN_lowestFreq_enum:
			ins->lowestFreq = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
wgclar_activate(LADSPA_Handle Instance)
{
	CLARIN * ins = (CLARIN *)Instance;
	clarinset(ins);
}

void
wgclar_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	CLARIN * ins = (CLARIN *)Instance;
	set_qcs_controlrate(SampleCount);
	clarin(ins);
}

void
wgclar_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_wgclar_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "wgclar";
	d->Name = "wgclar";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 11;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="reedStffns";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="attack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="noiseGain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="lowestFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = CLARIN_instantiate;
	d->connect_port = CLARIN_connect_port;
	d->activate = wgclar_activate;
	d->run = wgclar_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = wgclar_cleanup;
	return d;
}

enum descriptor_enum {
	wgclar_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *wgclar_desc_pointer;

	if (!inited) {
		wgclar_desc_pointer = new_wgclar_desc();

		inited=true;
	}
	
	switch(Index) {
		case wgclar_desc_enum : return wgclar_desc_pointer;

		default:
			return 0;
	}
}
