
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "channelops.h"


LADSPA_Handle
MIDIVAL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIVAL * i = new MIDIVAL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIVAL_port_enum {
	MIDIVAL_r_enum, MIDIVAL_irange_enum, 
};

void
MIDIVAL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIVAL * ins = (MIDIVAL *)Instance;
	switch(Port) {

		case MIDIVAL_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIVAL_irange_enum:
			ins->irange = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
MIDIBLOCK_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIBLOCK * i = new MIDIBLOCK;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIBLOCK_port_enum {
	MIDIBLOCK_port_enum, MIDIBLOCK_channel_enum, 
};

void
MIDIBLOCK_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIBLOCK * ins = (MIDIBLOCK *)Instance;
	switch(Port) {

		case MIDIBLOCK_port_enum:
			ins->port = DataLocation;
			break;

		case MIDIBLOCK_channel_enum:
			ins->channel = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIKMAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIKMAP * i = new MIDIKMAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIKMAP_port_enum {
	MIDIKMAP_r_enum, MIDIKMAP_ilo_enum, MIDIKMAP_ihi_enum, 
};

void
MIDIKMAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIKMAP * ins = (MIDIKMAP *)Instance;
	switch(Port) {

		case MIDIKMAP_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIKMAP_ilo_enum:
			ins->ilo = DataLocation;
			break;

		case MIDIKMAP_ihi_enum:
			ins->ihi = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
