
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "butter.h"


LADSPA_Handle
BFIL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BFIL * i = new BFIL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BFIL_port_enum {
	BFIL_sr_enum, BFIL_ain_enum, BFIL_kfc_enum, BFIL_istor_enum, 
};

void
BFIL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BFIL * ins = (BFIL *)Instance;
	switch(Port) {

		case BFIL_sr_enum:
			ins->sr = DataLocation;
			break;

		case BFIL_ain_enum:
			ins->ain = DataLocation;
			break;

		case BFIL_kfc_enum:
			ins->kfc = DataLocation;
			break;

		case BFIL_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
BBFIL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BBFIL * i = new BBFIL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BBFIL_port_enum {
	BBFIL_sr_enum, BBFIL_ain_enum, BBFIL_kfo_enum, BBFIL_kbw_enum, BBFIL_istor_enum, 
};

void
BBFIL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BBFIL * ins = (BBFIL *)Instance;
	switch(Port) {

		case BBFIL_sr_enum:
			ins->sr = DataLocation;
			break;

		case BBFIL_ain_enum:
			ins->ain = DataLocation;
			break;

		case BBFIL_kfo_enum:
			ins->kfo = DataLocation;
			break;

		case BBFIL_kbw_enum:
			ins->kbw = DataLocation;
			break;

		case BBFIL_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

void
butterbp_activate(LADSPA_Handle Instance)
{
	BBFIL * ins = (BBFIL *)Instance;
	bbutset(ins);
}

void
butterbp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BBFIL * ins = (BBFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	bpbut(ins);
}

void
butterbp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butterbp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butterbp";
	d->Name = "butterbp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfo";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BBFIL_instantiate;
	d->connect_port = BBFIL_connect_port;
	d->activate = butterbp_activate;
	d->run = butterbp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butterbp_cleanup;
	return d;
}

void
butterbr_activate(LADSPA_Handle Instance)
{
	BBFIL * ins = (BBFIL *)Instance;
	bbutset(ins);
}

void
butterbr_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BBFIL * ins = (BBFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	bcbut(ins);
}

void
butterbr_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butterbr_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butterbr";
	d->Name = "butterbr";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfo";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BBFIL_instantiate;
	d->connect_port = BBFIL_connect_port;
	d->activate = butterbr_activate;
	d->run = butterbr_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butterbr_cleanup;
	return d;
}

void
buthp_activate(LADSPA_Handle Instance)
{
	BFIL * ins = (BFIL *)Instance;
	butset(ins);
}

void
buthp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BFIL * ins = (BFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	hibut(ins);
}

void
buthp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_buthp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "buthp";
	d->Name = "buthp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfc";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BFIL_instantiate;
	d->connect_port = BFIL_connect_port;
	d->activate = buthp_activate;
	d->run = buthp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = buthp_cleanup;
	return d;
}

void
butterhp_activate(LADSPA_Handle Instance)
{
	BFIL * ins = (BFIL *)Instance;
	butset(ins);
}

void
butterhp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BFIL * ins = (BFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	hibut(ins);
}

void
butterhp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butterhp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butterhp";
	d->Name = "butterhp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfc";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BFIL_instantiate;
	d->connect_port = BFIL_connect_port;
	d->activate = butterhp_activate;
	d->run = butterhp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butterhp_cleanup;
	return d;
}

void
butbp_activate(LADSPA_Handle Instance)
{
	BBFIL * ins = (BBFIL *)Instance;
	bbutset(ins);
}

void
butbp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BBFIL * ins = (BBFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	bpbut(ins);
}

void
butbp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butbp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butbp";
	d->Name = "butbp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfo";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BBFIL_instantiate;
	d->connect_port = BBFIL_connect_port;
	d->activate = butbp_activate;
	d->run = butbp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butbp_cleanup;
	return d;
}

void
butlp_activate(LADSPA_Handle Instance)
{
	BFIL * ins = (BFIL *)Instance;
	butset(ins);
}

void
butlp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BFIL * ins = (BFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	lobut(ins);
}

void
butlp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butlp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butlp";
	d->Name = "butlp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfc";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BFIL_instantiate;
	d->connect_port = BFIL_connect_port;
	d->activate = butlp_activate;
	d->run = butlp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butlp_cleanup;
	return d;
}

void
butterlp_activate(LADSPA_Handle Instance)
{
	BFIL * ins = (BFIL *)Instance;
	butset(ins);
}

void
butterlp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BFIL * ins = (BFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	lobut(ins);
}

void
butterlp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butterlp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butterlp";
	d->Name = "butterlp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfc";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BFIL_instantiate;
	d->connect_port = BFIL_connect_port;
	d->activate = butterlp_activate;
	d->run = butterlp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butterlp_cleanup;
	return d;
}

void
butbr_activate(LADSPA_Handle Instance)
{
	BBFIL * ins = (BBFIL *)Instance;
	bbutset(ins);
}

void
butbr_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BBFIL * ins = (BBFIL *)Instance;
	set_qcs_controlrate(SampleCount);
	bcbut(ins);
}

void
butbr_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_butbr_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "butbr";
	d->Name = "butbr";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfo";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kbw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BBFIL_instantiate;
	d->connect_port = BBFIL_connect_port;
	d->activate = butbr_activate;
	d->run = butbr_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = butbr_cleanup;
	return d;
}

enum descriptor_enum {
	butterbr_desc_enum, butbp_desc_enum, butterbp_desc_enum, butterhp_desc_enum, buthp_desc_enum, butlp_desc_enum, butterlp_desc_enum, butbr_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *butterbr_desc_pointer;
	static LADSPA_Descriptor *butbp_desc_pointer;
	static LADSPA_Descriptor *butterbp_desc_pointer;
	static LADSPA_Descriptor *butterhp_desc_pointer;
	static LADSPA_Descriptor *buthp_desc_pointer;
	static LADSPA_Descriptor *butlp_desc_pointer;
	static LADSPA_Descriptor *butterlp_desc_pointer;
	static LADSPA_Descriptor *butbr_desc_pointer;

	if (!inited) {
		butterbr_desc_pointer = new_butterbr_desc();
		butbp_desc_pointer = new_butbp_desc();
		butterbp_desc_pointer = new_butterbp_desc();
		butterhp_desc_pointer = new_butterhp_desc();
		buthp_desc_pointer = new_buthp_desc();
		butlp_desc_pointer = new_butlp_desc();
		butterlp_desc_pointer = new_butterlp_desc();
		butbr_desc_pointer = new_butbr_desc();

		inited=true;
	}
	
	switch(Index) {
		case butterbr_desc_enum : return butterbr_desc_pointer;
		case butbp_desc_enum : return butbp_desc_pointer;
		case butterbp_desc_enum : return butterbp_desc_pointer;
		case butterhp_desc_enum : return butterhp_desc_pointer;
		case buthp_desc_enum : return buthp_desc_pointer;
		case butlp_desc_enum : return butlp_desc_pointer;
		case butterlp_desc_enum : return butterlp_desc_pointer;
		case butbr_desc_enum : return butbr_desc_pointer;

		default:
			return 0;
	}
}
