
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "brass.h"


LADSPA_Handle
BRASS_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BRASS * i = new BRASS;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BRASS_port_enum {
	BRASS_ar_enum, BRASS_amp_enum, BRASS_frequency_enum, BRASS_liptension_enum, BRASS_dettack_enum, BRASS_vibFreq_enum, BRASS_vibAmt_enum, BRASS_ifn_enum, BRASS_lowestFreq_enum, 
};

void
BRASS_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BRASS * ins = (BRASS *)Instance;
	switch(Port) {

		case BRASS_ar_enum:
			ins->ar = DataLocation;
			break;

		case BRASS_amp_enum:
			ins->amp = DataLocation;
			break;

		case BRASS_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case BRASS_liptension_enum:
			ins->liptension = DataLocation;
			break;

		case BRASS_dettack_enum:
			ins->dettack = DataLocation;
			break;

		case BRASS_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case BRASS_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case BRASS_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case BRASS_lowestFreq_enum:
			ins->lowestFreq = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
wgbrass_activate(LADSPA_Handle Instance)
{
	BRASS * ins = (BRASS *)Instance;
	brassset(ins);
}

void
wgbrass_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BRASS * ins = (BRASS *)Instance;
	set_qcs_controlrate(SampleCount);
	brass(ins);
}

void
wgbrass_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_wgbrass_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "wgbrass";
	d->Name = "wgbrass";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="liptension";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="lowestFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BRASS_instantiate;
	d->connect_port = BRASS_connect_port;
	d->activate = wgbrass_activate;
	d->run = wgbrass_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = wgbrass_cleanup;
	return d;
}

enum descriptor_enum {
	wgbrass_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *wgbrass_desc_pointer;

	if (!inited) {
		wgbrass_desc_pointer = new_wgbrass_desc();

		inited=true;
	}
	
	switch(Index) {
		case wgbrass_desc_enum : return wgbrass_desc_pointer;

		default:
			return 0;
	}
}
