
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "arith_ops.h"


LADSPA_Handle
CONVAL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CONVAL * i = new CONVAL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CONVAL_port_enum {
	CONVAL_r_enum, 
};

void
CONVAL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CONVAL * ins = (CONVAL *)Instance;
	switch(Port) {

		case CONVAL_r_enum:
			ins->r = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
ASSIGN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ASSIGN * i = new ASSIGN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ASSIGN_port_enum {
	ASSIGN_r_enum, ASSIGN_a_enum, 
};

void
ASSIGN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	switch(Port) {

		case ASSIGN_r_enum:
			ins->r = DataLocation;
			break;

		case ASSIGN_a_enum:
			ins->a = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
RELAT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RELAT * i = new RELAT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RELAT_port_enum {
	
};

void
RELAT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RELAT * ins = (RELAT *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
LOGCL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LOGCL * i = new LOGCL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LOGCL_port_enum {
	LOGCL_rbool_enum, LOGCL_ibool_enum, LOGCL_jbool_enum, 
};

void
LOGCL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LOGCL * ins = (LOGCL *)Instance;
	switch(Port) {

		case LOGCL_rbool_enum:
			ins->rbool = DataLocation;
			break;

		case LOGCL_ibool_enum:
			ins->ibool = DataLocation;
			break;

		case LOGCL_jbool_enum:
			ins->jbool = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
AOP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	AOP * i = new AOP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum AOP_port_enum {
	AOP_r_enum, AOP_a_enum, AOP_b_enum, 
};

void
AOP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	AOP * ins = (AOP *)Instance;
	switch(Port) {

		case AOP_r_enum:
			ins->r = DataLocation;
			break;

		case AOP_a_enum:
			ins->a = DataLocation;
			break;

		case AOP_b_enum:
			ins->b = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
EVAL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	EVAL * i = new EVAL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum EVAL_port_enum {
	EVAL_r_enum, EVAL_a_enum, 
};

void
EVAL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	EVAL * ins = (EVAL *)Instance;
	switch(Port) {

		case EVAL_r_enum:
			ins->r = DataLocation;
			break;

		case EVAL_a_enum:
			ins->a = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DIVZ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DIVZ * i = new DIVZ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DIVZ_port_enum {
	DIVZ_r_enum, DIVZ_a_enum, DIVZ_b_enum, DIVZ_def_enum, 
};

void
DIVZ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DIVZ * ins = (DIVZ *)Instance;
	switch(Port) {

		case DIVZ_r_enum:
			ins->r = DataLocation;
			break;

		case DIVZ_a_enum:
			ins->a = DataLocation;
			break;

		case DIVZ_b_enum:
			ins->b = DataLocation;
			break;

		case DIVZ_def_enum:
			ins->def = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
XENH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	XENH * i = new XENH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum XENH_port_enum {
	XENH_r_enum, XENH_pc_enum, XENH_et_enum, XENH_cy_enum, XENH_ref_enum, 
};

void
XENH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	XENH * ins = (XENH *)Instance;
	switch(Port) {

		case XENH_r_enum:
			ins->r = DataLocation;
			break;

		case XENH_pc_enum:
			ins->pc = DataLocation;
			break;

		case XENH_et_enum:
			ins->et = DataLocation;
			break;

		case XENH_cy_enum:
			ins->cy = DataLocation;
			break;

		case XENH_ref_enum:
			ins->ref = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MAOP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MAOP * i = new MAOP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MAOP_port_enum {
	MAOP_r_enum, MAOP_args_enum, 
};

void
MAOP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MAOP * ins = (MAOP *)Instance;
	switch(Port) {

		case MAOP_r_enum:
			ins->r = DataLocation;
			break;

		case MAOP_args_enum:
			ins->args = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
sub_Xa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_subScalarVector(ins);
}

void
sub_Xa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sub_Xa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sub_Xa";
	d->Name = "sub_Xa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = sub_Xa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sub_Xa_cleanup;
	return d;
}

void
taninv2_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	atan2aa(ins);
}

void
taninv2_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_taninv2_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "taninv2_a";
	d->Name = "taninv2_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = taninv2_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = taninv2_a_cleanup;
	return d;
}

void
div_Xa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divScalarVector(ins);
}

void
div_Xa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_div_Xa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "div_Xa";
	d->Name = "div_Xa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = div_Xa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = div_Xa_cleanup;
	return d;
}

void
k_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_AssignVector(ins);
}

void
k_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_k_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "k";
	d->Name = "k";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = k_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = k_cleanup;
	return d;
}

void
add_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_addVectors(ins);
}

void
add_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_add_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "add_aa";
	d->Name = "add_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = add_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = add_aa_cleanup;
	return d;
}

void
add_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_addVectorScalar(ins);
}

void
add_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_add_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "add_aX";
	d->Name = "add_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = add_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = add_aX_cleanup;
	return d;
}

void
sqrt_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	sqrta(ins);
}

void
sqrt_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sqrt_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sqrt_a";
	d->Name = "sqrt_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = sqrt_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sqrt_a_cleanup;
	return d;
}

void
cpsoct_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	acpsoct(ins);
}

void
cpsoct_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cpsoct_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cpsoct_a";
	d->Name = "cpsoct_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = cpsoct_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cpsoct_a_cleanup;
	return d;
}

void
mul_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_mulVectors(ins);
}

void
mul_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mul_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mul_aa";
	d->Name = "mul_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = mul_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mul_aa_cleanup;
	return d;
}

void
divz_ka_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DIVZ * ins = (DIVZ *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divzVectorScalar(ins);
}

void
divz_ka_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_divz_ka_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "divz_ka";
	d->Name = "divz_ka";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="def";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DIVZ_instantiate;
	d->connect_port = DIVZ_connect_port;
	d->activate = 0;
	d->run = divz_ka_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = divz_ka_cleanup;
	return d;
}

void
subeq_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_subeqVectorScalar(ins);
}

void
subeq_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_subeq_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "subeq_aX";
	d->Name = "subeq_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = subeq_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = subeq_aX_cleanup;
	return d;
}

void
exp_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	expa(ins);
}

void
exp_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_exp_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "exp_a";
	d->Name = "exp_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = exp_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = exp_a_cleanup;
	return d;
}

void
taninv_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	atana(ins);
}

void
taninv_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_taninv_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "taninv_a";
	d->Name = "taninv_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = taninv_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = taninv_a_cleanup;
	return d;
}

void
log_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	loga(ins);
}

void
log_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_log_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "log_a";
	d->Name = "log_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = log_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = log_a_cleanup;
	return d;
}

void
divz_ak_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DIVZ * ins = (DIVZ *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divzScalarVector(ins);
}

void
divz_ak_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_divz_ak_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "divz_ak";
	d->Name = "divz_ak";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="def";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DIVZ_instantiate;
	d->connect_port = DIVZ_connect_port;
	d->activate = 0;
	d->run = divz_ak_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = divz_ak_cleanup;
	return d;
}

void
subeq_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_subeqVectors(ins);
}

void
subeq_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_subeq_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "subeq_aa";
	d->Name = "subeq_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = subeq_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = subeq_aa_cleanup;
	return d;
}

void
sin_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	sina(ins);
}

void
sin_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sin_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sin_a";
	d->Name = "sin_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = sin_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sin_a_cleanup;
	return d;
}

void
mul_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_mulVectorScalar(ins);
}

void
mul_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mul_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mul_aX";
	d->Name = "mul_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = mul_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mul_aX_cleanup;
	return d;
}

void
sinh_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	sinha(ins);
}

void
sinh_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sinh_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sinh_a";
	d->Name = "sinh_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = sinh_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sinh_a_cleanup;
	return d;
}

void
tan_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	tana(ins);
}

void
tan_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tan_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tan_a";
	d->Name = "tan_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = tan_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tan_a_cleanup;
	return d;
}

void
sininv_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	asina(ins);
}

void
sininv_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sininv_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sininv_a";
	d->Name = "sininv_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = sininv_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sininv_a_cleanup;
	return d;
}

void
abs_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	absa(ins);
}

void
abs_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_abs_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "abs_a";
	d->Name = "abs_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = abs_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = abs_a_cleanup;
	return d;
}

void
pow_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_powVectorScalar(ins);
}

void
pow_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pow_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pow_aX";
	d->Name = "pow_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = pow_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pow_aX_cleanup;
	return d;
}

void
muleq_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_muleqVectors(ins);
}

void
muleq_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_muleq_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "muleq_aa";
	d->Name = "muleq_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = muleq_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = muleq_aa_cleanup;
	return d;
}

void
addeq_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_addeqVectorScalar(ins);
}

void
addeq_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_addeq_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "addeq_aX";
	d->Name = "addeq_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = addeq_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = addeq_aX_cleanup;
	return d;
}

void
mul_Xa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_mulScalarVector(ins);
}

void
mul_Xa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mul_Xa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mul_Xa";
	d->Name = "mul_Xa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = mul_Xa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mul_Xa_cleanup;
	return d;
}

void
cos_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	cosa(ins);
}

void
cos_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cos_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cos_a";
	d->Name = "cos_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = cos_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cos_a_cleanup;
	return d;
}

void
muleq_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_muleqVectorScalar(ins);
}

void
muleq_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_muleq_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "muleq_aX";
	d->Name = "muleq_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = muleq_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = muleq_aX_cleanup;
	return d;
}

void
addeq_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_addeqVectors(ins);
}

void
addeq_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_addeq_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "addeq_aa";
	d->Name = "addeq_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = addeq_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = addeq_aa_cleanup;
	return d;
}

void
divz_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DIVZ * ins = (DIVZ *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divzVectors(ins);
}

void
divz_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_divz_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "divz_aa";
	d->Name = "divz_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="def";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DIVZ_instantiate;
	d->connect_port = DIVZ_connect_port;
	d->activate = 0;
	d->run = divz_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = divz_aa_cleanup;
	return d;
}

void
tanh_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	tanha(ins);
}

void
tanh_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_tanh_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "tanh_a";
	d->Name = "tanh_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = tanh_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = tanh_a_cleanup;
	return d;
}

void
cosh_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	cosha(ins);
}

void
cosh_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cosh_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cosh_a";
	d->Name = "cosh_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = cosh_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cosh_a_cleanup;
	return d;
}

void
usub_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_usubVector(ins);
}

void
usub_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_usub_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "usub_a";
	d->Name = "usub_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = usub_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = usub_a_cleanup;
	return d;
}

void
pow_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_powVectors(ins);
}

void
pow_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pow_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pow_aa";
	d->Name = "pow_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = pow_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pow_aa_cleanup;
	return d;
}

void
ilogbtwo_activate(LADSPA_Handle Instance)
{
	EVAL * ins = (EVAL *)Instance;
	logbasetwo(ins);
}

void
ilogbtwo_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	logbasetwo(ins);
}

void
ilogbtwo_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_ilogbtwo_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "ilogbtwo";
	d->Name = "ilogbtwo";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = ilogbtwo_activate;
	d->run = ilogbtwo_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = ilogbtwo_cleanup;
	return d;
}

void
diveq_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_diveqVectorScalar(ins);
}

void
diveq_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_diveq_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "diveq_aX";
	d->Name = "diveq_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = diveq_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = diveq_aX_cleanup;
	return d;
}

void
cosinv_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	acosa(ins);
}

void
cosinv_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_cosinv_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "cosinv_a";
	d->Name = "cosinv_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = cosinv_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = cosinv_a_cleanup;
	return d;
}

void
sub_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_subVectorScalar(ins);
}

void
sub_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sub_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sub_aX";
	d->Name = "sub_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = sub_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sub_aX_cleanup;
	return d;
}

void
mod_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_modVectors(ins);
}

void
mod_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mod_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mod_aa";
	d->Name = "mod_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = mod_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mod_aa_cleanup;
	return d;
}

void
ipowoftwo_activate(LADSPA_Handle Instance)
{
	EVAL * ins = (EVAL *)Instance;
	powoftwo(ins);
}

void
ipowoftwo_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	powoftwo(ins);
}

void
ipowoftwo_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_ipowoftwo_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "ipowoftwo";
	d->Name = "ipowoftwo";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = ipowoftwo_activate;
	d->run = ipowoftwo_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = ipowoftwo_cleanup;
	return d;
}

void
iftlen2_activate(LADSPA_Handle Instance)
{
	EVAL * ins = (EVAL *)Instance;
	ftlen2(ins);
}

void
iftlen2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	ftsr(ins);
}

void
iftlen2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_iftlen2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "iftlen2";
	d->Name = "iftlen2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = iftlen2_activate;
	d->run = iftlen2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = iftlen2_cleanup;
	return d;
}

void
mod_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_modVectorScalar(ins);
}

void
mod_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mod_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mod_aX";
	d->Name = "mod_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = mod_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mod_aX_cleanup;
	return d;
}

void
div_aX_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divVectorScalar(ins);
}

void
div_aX_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_div_aX_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "div_aX";
	d->Name = "div_aX";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = div_aX_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = div_aX_cleanup;
	return d;
}

void
ampdb_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	aampdb(ins);
}

void
ampdb_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_ampdb_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "ampdb_a";
	d->Name = "ampdb_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = ampdb_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = ampdb_a_cleanup;
	return d;
}

void
sub_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_subVectors(ins);
}

void
sub_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sub_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sub_aa";
	d->Name = "sub_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = sub_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sub_aa_cleanup;
	return d;
}

void
div_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_divVectors(ins);
}

void
div_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_div_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "div_aa";
	d->Name = "div_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = div_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = div_aa_cleanup;
	return d;
}

void
add_Xa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	AOP * ins = (AOP *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_addScalarVector(ins);
}

void
add_Xa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_add_Xa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "add_Xa";
	d->Name = "add_Xa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = AOP_instantiate;
	d->connect_port = AOP_connect_port;
	d->activate = 0;
	d->run = add_Xa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = add_Xa_cleanup;
	return d;
}

void
diveq_aa_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ASSIGN * ins = (ASSIGN *)Instance;
	set_qcs_controlrate(SampleCount);
	inline_diveqVectors(ins);
}

void
diveq_aa_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_diveq_aa_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "diveq_aa";
	d->Name = "diveq_aa";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ASSIGN_instantiate;
	d->connect_port = ASSIGN_connect_port;
	d->activate = 0;
	d->run = diveq_aa_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = diveq_aa_cleanup;
	return d;
}

void
log10_a_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	EVAL * ins = (EVAL *)Instance;
	set_qcs_controlrate(SampleCount);
	log10a(ins);
}

void
log10_a_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_log10_a_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "log10_a";
	d->Name = "log10_a";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="a";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = EVAL_instantiate;
	d->connect_port = EVAL_connect_port;
	d->activate = 0;
	d->run = log10_a_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = log10_a_cleanup;
	return d;
}

enum descriptor_enum {
	sininv_a_desc_enum, sub_Xa_desc_enum, abs_a_desc_enum, pow_aX_desc_enum, muleq_aa_desc_enum, div_Xa_desc_enum, k_desc_enum, addeq_aX_desc_enum, add_aa_desc_enum, cosh_a_desc_enum, sinh_a_desc_enum, diveq_aX_desc_enum, cos_a_desc_enum, taninv_a_desc_enum, ilogbtwo_desc_enum, muleq_aX_desc_enum, add_aX_desc_enum, addeq_aa_desc_enum, taninv2_a_desc_enum, divz_aa_desc_enum, ampdb_a_desc_enum, mul_Xa_desc_enum, tanh_a_desc_enum, sqrt_a_desc_enum, usub_a_desc_enum, pow_aa_desc_enum, cpsoct_a_desc_enum, mul_aa_desc_enum, cosinv_a_desc_enum, sub_aX_desc_enum, divz_ka_desc_enum, div_aX_desc_enum, subeq_aX_desc_enum, mod_aa_desc_enum, exp_a_desc_enum, log_a_desc_enum, ipowoftwo_desc_enum, log10_a_desc_enum, diveq_aa_desc_enum, mod_aX_desc_enum, tan_a_desc_enum, sub_aa_desc_enum, divz_ak_desc_enum, add_Xa_desc_enum, subeq_aa_desc_enum, div_aa_desc_enum, sin_a_desc_enum, mul_aX_desc_enum, iftlen2_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *sininv_a_desc_pointer;
	static LADSPA_Descriptor *sub_Xa_desc_pointer;
	static LADSPA_Descriptor *abs_a_desc_pointer;
	static LADSPA_Descriptor *pow_aX_desc_pointer;
	static LADSPA_Descriptor *muleq_aa_desc_pointer;
	static LADSPA_Descriptor *div_Xa_desc_pointer;
	static LADSPA_Descriptor *k_desc_pointer;
	static LADSPA_Descriptor *addeq_aX_desc_pointer;
	static LADSPA_Descriptor *add_aa_desc_pointer;
	static LADSPA_Descriptor *cosh_a_desc_pointer;
	static LADSPA_Descriptor *sinh_a_desc_pointer;
	static LADSPA_Descriptor *diveq_aX_desc_pointer;
	static LADSPA_Descriptor *cos_a_desc_pointer;
	static LADSPA_Descriptor *taninv_a_desc_pointer;
	static LADSPA_Descriptor *ilogbtwo_desc_pointer;
	static LADSPA_Descriptor *muleq_aX_desc_pointer;
	static LADSPA_Descriptor *add_aX_desc_pointer;
	static LADSPA_Descriptor *addeq_aa_desc_pointer;
	static LADSPA_Descriptor *taninv2_a_desc_pointer;
	static LADSPA_Descriptor *divz_aa_desc_pointer;
	static LADSPA_Descriptor *ampdb_a_desc_pointer;
	static LADSPA_Descriptor *mul_Xa_desc_pointer;
	static LADSPA_Descriptor *tanh_a_desc_pointer;
	static LADSPA_Descriptor *sqrt_a_desc_pointer;
	static LADSPA_Descriptor *usub_a_desc_pointer;
	static LADSPA_Descriptor *pow_aa_desc_pointer;
	static LADSPA_Descriptor *cpsoct_a_desc_pointer;
	static LADSPA_Descriptor *mul_aa_desc_pointer;
	static LADSPA_Descriptor *cosinv_a_desc_pointer;
	static LADSPA_Descriptor *sub_aX_desc_pointer;
	static LADSPA_Descriptor *divz_ka_desc_pointer;
	static LADSPA_Descriptor *div_aX_desc_pointer;
	static LADSPA_Descriptor *subeq_aX_desc_pointer;
	static LADSPA_Descriptor *mod_aa_desc_pointer;
	static LADSPA_Descriptor *exp_a_desc_pointer;
	static LADSPA_Descriptor *log_a_desc_pointer;
	static LADSPA_Descriptor *ipowoftwo_desc_pointer;
	static LADSPA_Descriptor *log10_a_desc_pointer;
	static LADSPA_Descriptor *diveq_aa_desc_pointer;
	static LADSPA_Descriptor *mod_aX_desc_pointer;
	static LADSPA_Descriptor *tan_a_desc_pointer;
	static LADSPA_Descriptor *sub_aa_desc_pointer;
	static LADSPA_Descriptor *divz_ak_desc_pointer;
	static LADSPA_Descriptor *add_Xa_desc_pointer;
	static LADSPA_Descriptor *subeq_aa_desc_pointer;
	static LADSPA_Descriptor *div_aa_desc_pointer;
	static LADSPA_Descriptor *sin_a_desc_pointer;
	static LADSPA_Descriptor *mul_aX_desc_pointer;
	static LADSPA_Descriptor *iftlen2_desc_pointer;

	if (!inited) {
		sininv_a_desc_pointer = new_sininv_a_desc();
		sub_Xa_desc_pointer = new_sub_Xa_desc();
		abs_a_desc_pointer = new_abs_a_desc();
		pow_aX_desc_pointer = new_pow_aX_desc();
		muleq_aa_desc_pointer = new_muleq_aa_desc();
		div_Xa_desc_pointer = new_div_Xa_desc();
		k_desc_pointer = new_k_desc();
		addeq_aX_desc_pointer = new_addeq_aX_desc();
		add_aa_desc_pointer = new_add_aa_desc();
		cosh_a_desc_pointer = new_cosh_a_desc();
		sinh_a_desc_pointer = new_sinh_a_desc();
		diveq_aX_desc_pointer = new_diveq_aX_desc();
		cos_a_desc_pointer = new_cos_a_desc();
		taninv_a_desc_pointer = new_taninv_a_desc();
		ilogbtwo_desc_pointer = new_ilogbtwo_desc();
		muleq_aX_desc_pointer = new_muleq_aX_desc();
		add_aX_desc_pointer = new_add_aX_desc();
		addeq_aa_desc_pointer = new_addeq_aa_desc();
		taninv2_a_desc_pointer = new_taninv2_a_desc();
		divz_aa_desc_pointer = new_divz_aa_desc();
		ampdb_a_desc_pointer = new_ampdb_a_desc();
		mul_Xa_desc_pointer = new_mul_Xa_desc();
		tanh_a_desc_pointer = new_tanh_a_desc();
		sqrt_a_desc_pointer = new_sqrt_a_desc();
		usub_a_desc_pointer = new_usub_a_desc();
		pow_aa_desc_pointer = new_pow_aa_desc();
		cpsoct_a_desc_pointer = new_cpsoct_a_desc();
		mul_aa_desc_pointer = new_mul_aa_desc();
		cosinv_a_desc_pointer = new_cosinv_a_desc();
		sub_aX_desc_pointer = new_sub_aX_desc();
		divz_ka_desc_pointer = new_divz_ka_desc();
		div_aX_desc_pointer = new_div_aX_desc();
		subeq_aX_desc_pointer = new_subeq_aX_desc();
		mod_aa_desc_pointer = new_mod_aa_desc();
		exp_a_desc_pointer = new_exp_a_desc();
		log_a_desc_pointer = new_log_a_desc();
		ipowoftwo_desc_pointer = new_ipowoftwo_desc();
		log10_a_desc_pointer = new_log10_a_desc();
		diveq_aa_desc_pointer = new_diveq_aa_desc();
		mod_aX_desc_pointer = new_mod_aX_desc();
		tan_a_desc_pointer = new_tan_a_desc();
		sub_aa_desc_pointer = new_sub_aa_desc();
		divz_ak_desc_pointer = new_divz_ak_desc();
		add_Xa_desc_pointer = new_add_Xa_desc();
		subeq_aa_desc_pointer = new_subeq_aa_desc();
		div_aa_desc_pointer = new_div_aa_desc();
		sin_a_desc_pointer = new_sin_a_desc();
		mul_aX_desc_pointer = new_mul_aX_desc();
		iftlen2_desc_pointer = new_iftlen2_desc();

		inited=true;
	}
	
	switch(Index) {
		case sininv_a_desc_enum : return sininv_a_desc_pointer;
		case sub_Xa_desc_enum : return sub_Xa_desc_pointer;
		case abs_a_desc_enum : return abs_a_desc_pointer;
		case pow_aX_desc_enum : return pow_aX_desc_pointer;
		case muleq_aa_desc_enum : return muleq_aa_desc_pointer;
		case div_Xa_desc_enum : return div_Xa_desc_pointer;
		case k_desc_enum : return k_desc_pointer;
		case addeq_aX_desc_enum : return addeq_aX_desc_pointer;
		case add_aa_desc_enum : return add_aa_desc_pointer;
		case cosh_a_desc_enum : return cosh_a_desc_pointer;
		case sinh_a_desc_enum : return sinh_a_desc_pointer;
		case diveq_aX_desc_enum : return diveq_aX_desc_pointer;
		case cos_a_desc_enum : return cos_a_desc_pointer;
		case taninv_a_desc_enum : return taninv_a_desc_pointer;
		case ilogbtwo_desc_enum : return ilogbtwo_desc_pointer;
		case muleq_aX_desc_enum : return muleq_aX_desc_pointer;
		case add_aX_desc_enum : return add_aX_desc_pointer;
		case addeq_aa_desc_enum : return addeq_aa_desc_pointer;
		case taninv2_a_desc_enum : return taninv2_a_desc_pointer;
		case divz_aa_desc_enum : return divz_aa_desc_pointer;
		case ampdb_a_desc_enum : return ampdb_a_desc_pointer;
		case mul_Xa_desc_enum : return mul_Xa_desc_pointer;
		case tanh_a_desc_enum : return tanh_a_desc_pointer;
		case sqrt_a_desc_enum : return sqrt_a_desc_pointer;
		case usub_a_desc_enum : return usub_a_desc_pointer;
		case pow_aa_desc_enum : return pow_aa_desc_pointer;
		case cpsoct_a_desc_enum : return cpsoct_a_desc_pointer;
		case mul_aa_desc_enum : return mul_aa_desc_pointer;
		case cosinv_a_desc_enum : return cosinv_a_desc_pointer;
		case sub_aX_desc_enum : return sub_aX_desc_pointer;
		case divz_ka_desc_enum : return divz_ka_desc_pointer;
		case div_aX_desc_enum : return div_aX_desc_pointer;
		case subeq_aX_desc_enum : return subeq_aX_desc_pointer;
		case mod_aa_desc_enum : return mod_aa_desc_pointer;
		case exp_a_desc_enum : return exp_a_desc_pointer;
		case log_a_desc_enum : return log_a_desc_pointer;
		case ipowoftwo_desc_enum : return ipowoftwo_desc_pointer;
		case log10_a_desc_enum : return log10_a_desc_pointer;
		case diveq_aa_desc_enum : return diveq_aa_desc_pointer;
		case mod_aX_desc_enum : return mod_aX_desc_pointer;
		case tan_a_desc_enum : return tan_a_desc_pointer;
		case sub_aa_desc_enum : return sub_aa_desc_pointer;
		case divz_ak_desc_enum : return divz_ak_desc_pointer;
		case add_Xa_desc_enum : return add_Xa_desc_pointer;
		case subeq_aa_desc_enum : return subeq_aa_desc_pointer;
		case div_aa_desc_enum : return div_aa_desc_pointer;
		case sin_a_desc_enum : return sin_a_desc_pointer;
		case mul_aX_desc_enum : return mul_aX_desc_pointer;
		case iftlen2_desc_enum : return iftlen2_desc_pointer;

		default:
			return 0;
	}
}
