#ifndef __qm__
#define __qm__

#include <sys/types.h>
#include <iostream>

typedef float Number; 

#if 0
ostream& info = cout;
ostream& error = cerr;
ostream& warning = cerr;
ostream& fatal = cerr;

#else

extern ostream& info;
extern ostream& error;
extern ostream& warning;
extern ostream& fatal;
#define endmsg endl
#endif

//#define extern
extern Number FrameRate;      /* number of frames per second */
extern Number ControlRate;    /* number of DSP cycles per second */
extern size_t CycleFrames;    /* frames generated per DSP cycle */
extern Number nCycleFrames;   /* ditto, as floating point */
extern size_t FrameSamples;   /* samples per frame (== channels) */
extern Number pi;
extern const Number fmaxlen; //const Number fmaxlen = FunctionTable::MaximumTableSize;
extern Number sicvt; // sicvt = fmaxlen / FrameRate;
extern const Number twopi; // const Number twopi = TWOPI_F;

extern Number tpidsr;
extern Number mtpdsr;
extern Number mpidsr;
extern Number onedkr;
extern Number onedsr;
extern Number kicvt;
extern Number dv32768;


//#undef extern
/* provide this for backwards compatibility with Csound */

#define ksmps  CycleFrames
#define ensmps nCycleFrames
#define esr    FrameRate
#define ekr    ControlRate
#define nchnls FrameSamples

#define  PMASK      0x0FFFFFFL
#define MAXPOS     0x7FFFFFFFL
#define  MAXLEN              0x1000000L
#define LOBITS     10
#define LOMASK     1023

// constants.h
#define STEPS 32768 
#define OCTAVES 5.
#define INTERVAL 4.
#define FZERO	0.0f
#define FONE	1.0f
#define FHUND   100.0f

#ifndef PI
#ifdef M_PI
#define        PI M_PI
#else
#define        PI	3.14159265358979323846
#endif // M_PI
#endif // PI

#ifndef M_PI
#define M_PI PI
#endif

#ifndef TWOPI
#define        TWOPI   (6.28318530717958647692)
#endif  // TWOPI

#ifndef PI_F
#define        PI_F    (3.14159265358979323846f)
#endif  // PI_F

#ifndef TWOPI_F
#define        TWOPI_F        (6.28318530717958647692f)
#endif  // TWOPI_F 


#endif // __qm__
