/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: opcode_defs.h,v 1.2 1999/11/08 08:00:36 stef Exp $
*/

#ifndef __qm_opcode_defs_h__
#define __qm_opcode_defs_h__

//#include <quasimodo/dsp_instruction.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdarg.h>

#include "qm.h"

typedef float Number; 
typedef double Dumber; 
typedef float sample_t;
typedef int int32;
typedef short int16;
typedef unsigned int uint32;
typedef unsigned short uint16;

#define VARGMAX  801
#ifndef NULL
#define NULL 0
#endif

struct DspInstruction {
	uint32          audio_args;     /* bitmask for arguments that are audio */
	size_t          in_argc;        /* how many input arguments */       \
	size_t          out_argc;       /* how many output arguments */ \

	void error (const char *fmt, ...) {
		va_list ap;
		va_start (ap, fmt);
		fprintf(stderr, fmt,ap);
		va_end (ap);
	}
};

#define OpcodeArgument(name) struct name : DspInstruction {



#define	INOCOUNT   in_argc
#define	OUTOCOUNT  out_argc

#define has_audio_arguments() audio_args ? 1 : 0
#define nth_arg_is_audio(n)   audio_args&(1<<(n)) ? 1 : 0


/* an argument type for opcodes not taking any arguments */

OpcodeArgument(BASIC_OP_ARG)
};



#endif // __qm_opcode_defs_h__
