#ifndef __opcode_h__
#define __opcode_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/stringptr.h>

typedef	void  (*OpcodeFunction)(void *);
#define S(class) 0
// &class::make
#define F(f)    (OpcodeFunction)f

enum ThreadType {
       OrchestraTime = 0xff,
       InitTime = 0x1,
       EventTime = 0x2,
       AudioTime = 0x4
};

struct Opcode {
	char	       *opname;
	OpcodeFunction factory;
	uint16		exec_time;    /* OR-ed from OpcodeThread values */
    char	       *out_types;
	char	       *in_types;
	OpcodeFunction	i_function;
	OpcodeFunction	k_function;
	OpcodeFunction	a_function;
	uint32          flags;
	const char     *dependencies;
};

#endif // __opcode_h__
