#include <math.h>
#include <sys/types.h>
#include <iostream>

typedef float Number;

#define extern
extern Number FrameRate;      /* number of frames per second */
extern Number ControlRate;    /* number of DSP cycles per second */
extern size_t CycleFrames;    /* frames generated per DSP cycle */
extern Number nCycleFrames;   /* ditto, as floating point */
extern size_t FrameSamples;   /* samples per frame (== channels) */

extern Number fmaxlen; //const Number fmaxlen = FunctionTable::MaximumTableSize;
extern Number sicvt; // sicvt = fmaxlen / FrameRate;

extern Number pi;
extern Number twopi; // const Number twopi = TWOPI_F;
extern Number tpidsr;
extern Number mtpdsr;
extern Number mpidsr;
extern Number onedkr;
extern Number onedsr;
extern Number kicvt;
extern Number dv32768;
#undef extern

#if 1
ostream& info = cout;
ostream& error = cerr;
ostream& warning = cerr;
ostream& fatal = cerr;
#endif



void
set_qcs_framerate(unsigned long framerate)
{
	FrameRate = framerate;
	fmaxlen = 8192;
	sicvt = fmaxlen / FrameRate;
	
	pi=M_PI;
	twopi=2*pi;
	tpidsr=twopi/FrameRate;
	mtpdsr = -tpidsr;
	mpidsr = -pi/FrameRate;
	onedsr = 1/FrameRate;
}

void
set_qcs_controlrate(unsigned long samplecount)
{
	ControlRate = FrameRate/samplecount;
	nCycleFrames = FrameRate / ControlRate;
	CycleFrames = nCycleFrames;
	
	onedkr = 1/ControlRate;
}


