import os
import re
import string

path=[]
path.append("opcodes-gpl/")
path.append("opcodes-non-gpl/")

l=[]
for i in path:
	l.extend(os.listdir(i))


lh=[]
for i in l:
	if i[-2:]==".h":
		lh.append(i[:-2])

rm = ["multisample","fof3", "follow", "foscili2", "generators_gpl", "grain", "lpc", "physutil"]

try:
	for i in rm:
		lh.remove(i)
except:
	pass

rm=["generators", "random"]
#rm = ["generators","random", "arith_ops"]
#rm = rm + ["midiops", "vdelay"]
try:
	for i in rm:
		lh.remove(i)
except:
	pass

Comment_re = re.compile("/\*.*\*/")
OpcodeArgument_re = re.compile("OpcodeArgument\(((\w|\d)+)\)")
Number_re = re.compile("\s*\;?(\n|\s)*Number")
#NumberPointer_re = re.compile("\*\s*((\w|\d|_|\[|\])+)") #grab toto[...]
NumberPointer_re = re.compile("\*\s*((\w|\d|_|\*|\+|\-)+)") #grab toto[NB*2+TTI_]
EndOpcode_re = re.compile("}\s*;")

OpcodeList_re = re.compile("_OPCODES?_LIST")

#"wgflute"
OpcodeName_re = re.compile("\"((\w|\d|_)+)\"")
#S(FLUTE)
OpcodeStruct_re = re.compile("S\(((\w|\d|_)+)")
#InitTime|AudioTime
OpcodeTime_re = re.compile("((\w|\d|_|\s|\|)+)")
#"a"
OpcodeOutTypes_re = re.compile("\"(\w*)\"")
#"kkkiikkkiovv"
OpcodeInType_re = re.compile("\"(\w*)\"")
#F(fluteset)
#NULL
#F(flute)
OpcodeFunction_re = re.compile("F\(((\w|\d|_)+)|NULL")
OpcodeFunctionNULL_re = re.compile("NULL")
#0
#"physutil"


class OpcodeArgument:
	def __init__(self, Name=None, Ports=[]):
		self.Name=Name
		self.Ports=Ports
		
	def get_desc_text(self):
		instantiate = """
LADSPA_Handle
%s_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	%s * i = new %s;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}
"""%(self.Name, self.Name, self.Name)

		enum_port = """
enum %s_port_enum {
"""%(self.Name)

		p=""
		for i in self.Ports:
			p = p+self.Name+"_"+i+"_enum, "
		
		enum_port = enum_port + "\t" + p + "\n};\n"

		connect_port = """
void
%s_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	%s * ins = (%s *)Instance;
	switch(Port) {
"""	%(self.Name, self.Name, self.Name)	

		p=""
		for i in self.Ports:
			p = p+ """
		case %s_%s_enum:
			ins->%s = DataLocation;
			break;
"""%(self.Name, i, i)
			
		
		connect_port = connect_port + p + """
		default:
			break;
	}
}
"""
		functions = instantiate + enum_port + connect_port
		return functions
		

class PlugIn:
	def __init__(self, OpcodeArgument=None, OpcodeName=None, OpcodeTime=None, OutTypes=None, InTypes=None, FunctionInit=None, FunctionControl=None, FunctionAudio=None):
		self.OpcodeArgument, self.OpcodeName, self.OpcodeTime, self.OutTypes, self.InTypes, self.FunctionInit, self.FunctionControl, self.FunctionAudio \
		= OpcodeArgument, OpcodeName, OpcodeTime, OutTypes, InTypes, FunctionInit, FunctionControl, FunctionAudio

	def get_desc_text(self):
		if(self.FunctionAudio==None):
			raise "NoAudioFunction"
		if(self.FunctionInit):
			activate = """
void
%s_activate(LADSPA_Handle Instance)
{
	%s * ins = (%s *)Instance;
	%s(ins);
}
"""%(self.OpcodeName, self.OpcodeArgument.Name, self.OpcodeArgument.Name, self.FunctionInit)
		else:
			activate=""

		run = """
void
%s_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	%s * ins = (%s *)Instance;
	set_qcs_controlrate(SampleCount);
	%s(ins);
}
"""%(self.OpcodeName, self.OpcodeArgument.Name, self.OpcodeArgument.Name, self.FunctionAudio)

		cleanup = """
void
%s_cleanup(LADSPA_Handle)
{
}
"""%(self.OpcodeName)

		functions = activate + run + cleanup

		if(self.FunctionInit):
			act=self.OpcodeName+"_activate"
		else:
			act=0

		p=""
		if(self.OutTypes==None and self.InTypes==None):
			pass
		else:
			types = self.OutTypes+self.InTypes
			for i in range(len(types)):
				t = types[i]
				if t=='a':
					t="LADSPA_PORT_AUDIO"
				else:
					t="LADSPA_PORT_CONTROL"
				if i < len(self.OutTypes):
					t = t + " | LADSPA_PORT_OUTPUT"
				else:
					t = t + " | LADSPA_PORT_INPUT"


				p=p+"""
		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[%s]=%s;
		const_cast<const char**>(d->PortNames)[%s]="%s";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[%s].HintDescriptor=0;
"""%(i,t,i,self.OpcodeArgument.Ports[i], i)
	
		new_desc = """
LADSPA_Descriptor*
new_%s_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "%s";
	d->Name = "%s";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = %s;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {
%s
	}
	d->ImplementationData = 0;
	d->instantiate = %s_instantiate;
	d->connect_port = %s_connect_port;
	d->activate = %s;
	d->run = %s_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = %s_cleanup;
	return d;
}
"""%(self.OpcodeName, self.OpcodeName, self.OpcodeName, len(self.InTypes+self.OutTypes), p, self.OpcodeArgument.Name, self.OpcodeArgument.Name, act, self.OpcodeName, self.OpcodeName )
	
		content = functions + new_desc
		return content
		

def parse_plugin(content):
	BASIC_OP_ARG = OpcodeArgument(Name="BASIC_OP_ARG")
	opargs={}
	opargs["BASIC_OP_ARG"]=BASIC_OP_ARG

	pos=0
	while 1:
		m=Comment_re.search(content, pos)
		if m==None:
			break
		content=content[:m.start(0)]+content[m.end(0):]
		pos = m.start(0)
		
	pos=0
	while(1):
		m=OpcodeArgument_re.search(content, pos)
		if m==None:
			break
		OpcodeArgument_ = m.group(1)
		opargs[OpcodeArgument_]=OpcodeArgument(Name=OpcodeArgument_)

		pos = m.regs[1][1]+1 # right parenthesis
		m=EndOpcode_re.search(content, pos)
		end=m.regs[0][1]
		
		ports=[]	
		while 1:
			m=Number_re.match(content, pos)
			if m==None:
				break
			pos1 = m.regs[0][1]
			if pos1>end:
				break
			pos=pos1
			endline = string.find(content, ';', pos)
#			print m.group(1)
			while(1):
				n=NumberPointer_re.search(content, pos)
				if n==None:
					break
				m=n
				pos1 = m.regs[1][1]
				if pos1>endline:
#					print "####"
					break
				pos=pos1
				arg = n.group(1)
				# forget arrays
#				if string.find(arg,'[')<0:
				ports.append(arg)
			if pos>end:
				break

		opargs[OpcodeArgument_].Ports=ports

	m=OpcodeList_re.search(content, pos)
	pos = m.regs[0][1]
	plugins={}
	while 1:
		m=OpcodeName_re.search(content, pos)
		if m==None:
			break
		OpcodeName = m.group(1)
		pos = m.regs[1][1]
		
		m=OpcodeStruct_re.search(content, pos)
		OpcodeStruct = m.group(1)
		pos = m.regs[1][1]

		m=OpcodeTime_re.search(content, pos)
		OpcodeTime = m.group(1)
		pos = m.regs[1][1]
	
		m=OpcodeOutTypes_re.search(content, pos)
		OpcodeOutTypes = m.group(1)
		pos = m.regs[1][1]

		m=OpcodeInType_re.search(content, pos)
		OpcodeInType = m.group(1)
		pos = m.regs[1][1]
	
		m=OpcodeFunction_re.search(content, pos)
		OpcodeFunction1=m.group(0)
		if OpcodeFunction1=="NULL":
			OpcodeFunction1=None
			pos= m.regs[0][1]
		else:
			OpcodeFunction1=m.group(1)
			pos = m.regs[1][1]
#		print "f1 ", OpcodeFunction1

		m=OpcodeFunction_re.search(content, pos)
		OpcodeFunction2=m.group(0)
		if OpcodeFunction2=="NULL":
			OpcodeFunction2=None
			pos= m.regs[0][1]
		else:
			OpcodeFunction2=m.group(1)
			pos = m.regs[1][1]
#		print "f2 ", OpcodeFunction2

		m=OpcodeFunction_re.search(content, pos)
		OpcodeFunction3=m.group(0)
		if OpcodeFunction3=="NULL":
			OpcodeFunction3=None
			pos= m.regs[0][1]
		else:
			OpcodeFunction3=m.group(1)
			pos = m.regs[1][1]
#		print "f3 ", OpcodeFunction3
		
		pos=string.find(content, "}", pos)
		
		oparg = opargs[OpcodeStruct]
		p = PlugIn()
		p.OpcodeArgument = oparg
		p.OpcodeName = OpcodeName
		p.OpcodeTime = OpcodeTime
		p.OutTypes = OpcodeOutTypes
		p.InTypes = OpcodeInType
		p.FunctionInit = OpcodeFunction1
		p.FunctionControl = OpcodeFunction2
		p.FunctionAudio = OpcodeFunction3
		plugins[p.OpcodeName]=p		

	return (opargs, plugins)


def create_wrapper(filename, opargs, plugins):

	content = ""
	content = content +"""
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
"""

	content = content + '#include "%s.h"\n\n' %(filename)

	for i in opargs.items():
		p=i[1]
		content = content + p.get_desc_text()

	ppp = {}
	for i in plugins.items():
		p=i[1]
		try:
			c = p.get_desc_text()
			content = content + c
			ppp[p.OpcodeName]=p
		except:
			print "couldn't handle %s (file %s.h)"%(p.OpcodeName,filename)
	plugins=ppp

	content =content + """
enum descriptor_enum {
"""
	content = content + "\t"
	for i in plugins.items():
		p=i[1]
		content = content + p.OpcodeName + '_desc_enum, '

	content =content + """
};
"""

	content = content + """
const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
"""


	for i in plugins.items():
		p=i[1]
		content = content + "\tstatic LADSPA_Descriptor *" + p.OpcodeName + '_desc_pointer;\n'

	content = content + """
	if (!inited) {
"""

	for i in plugins.items():
		p=i[1]
		content = content + "\t\t" + p.OpcodeName + '_desc_pointer = new_' + p.OpcodeName + '_desc();\n'

	content = content + """
		inited=true;
	}
	
	switch(Index) {
"""

	for i in plugins.items():
		p=i[1]
		content = content + "\t\tcase " + p.OpcodeName + '_desc_enum :' \
			+ " return " + p.OpcodeName + '_desc_pointer' + ";\n"

	content = content + """
		default:
			return 0;
	}
}
"""
	
	
	return content


files={}
for i in lh:
#i="harmon"
#while(1):
#	print '--- ', i
	# beeeurk
	try:
		f=open(path[0]+i+'.h','r')
	except:
		f=open(path[1]+i+'.h','r')

	content=f.read()
	opargs, plugins = parse_plugin(content)
	files[i]= (opargs,plugins)

if len(files):
	for i in files.items():
#		if(i[0]=="harmon"):
		try:
			content = create_wrapper(i[0], i[1][0], i[1][1])
			f=open("results/%s_ladspa.cc"%i[0], 'w')
			f.write(content)
		except:
			print "file:", i[0]
			raise
		
		
