#include "cs.h"			/*                             WINDIN.C  
				 */
#include "entry.h"
#include "insert.h"
#include "window.h"
#include "windin.h"		/* real-time input control units  */
				/* 26aug90 dpwe                         */

void
xyinset(XYIN * p)
{
	float f;

	if ((p->timcount = (int) (ekr * *p->iprd)) <= 0)
		error << "INIT: illegal iprd" << endmsg;

	if (*p->iymin > *p->iymax) {	/* swap if wrong order */
		f = *p->iymin;
		*p->iymin = *p->iymax;
		*p->iymax = f;
	}
	if (*p->iymin == *p->iymax) {	/* force some room (why?) */
		*p->iymax = *p->iymin + 1.0f;	/* say.. */
		*p->iymin -= 1.0f;
	}
	if (*p->iyinit < *p->iymin)
		*p->iyinit = *p->iymin;
	else if (*p->iyinit > *p->iymax)
		*p->iyinit = *p->iymax;

	if (*p->ixmin > *p->ixmax) {	/* swap if wrong order */
		f = *p->ixmin;
		*p->ixmin = *p->ixmax;
		*p->ixmax = f;
	}
	if (*p->ixmin == *p->ixmax) {	/* force some room (why?) */
		*p->ixmax = *p->ixmin + 1.0f;	/* say.. */
		*p->ixmin -= 1.0f;
	}
	if (*p->ixinit < *p->ixmin)
		*p->ixinit = *p->ixmin;
	else if (*p->ixinit > *p->ixmax)
		*p->ixinit = *p->ixmax;

	(*mkxyFn) (&p->w, (*p->ixinit - *p->ixmin) / (*p->ixmax - *p->ixmin),
		   (*p->iyinit - *p->iymin) / (*p->iymax - *p->iymin));

	p->countdown = 1;	/* init counter to run xyin on first call */
}

void
xyin(XYIN * p)
{
	if (!(--p->countdown)) {	/* at each countdown   */
		p->countdown = p->timcount;	/*   reset counter &   */
		(*rdxyFn) (&p->w);	/*   read cursor postn */
		*(p->kxrslt) = *p->ixmin + p->w.x * (*p->ixmax - *p->ixmin);
		*(p->kyrslt) = *p->iymin + (1.0f - p->w.y) * (*p->iymax -
							      *p->iymin);
		/*  info << "x: " << *p->kxrslt << "   y:" << *p->kyrslt << " \n" << endmsg;
 */
	}
}

OENTRY opcodes[] =
{
	{"xyin", S(XYIN), 3, "kk", "iiiiioo", F(xyinset), F(xyin)},
	{NULL}
};
