#ifndef __spectra_h__
#define __spectra_h__


        		/*					SPECTRA.H	*/

#define MAXFRQS 120

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	float	*signal,*iprd,*iocts,*ifrqs,*iq,*ihann;
        float   *idbout,*idisprd,*idsines;
	int	nfreqs, hanning, ncoefs, dbout, nsmps, scountdown, timcount;
	float	curq, *sinp, *cosp, *linbufp;
	int     disprd, dcountdown, winlen[MAXFRQS], offset[MAXFRQS];
	DOWNDAT downsig;
	WINDAT  sinwindow, octwindow;
	AUXCH	auxch1, auxch2;
} SPECTRUM;

#ifdef never
typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	DOWNDAT *dsig;
	float	*iprd, *ifrqs, *iq, *ihann, *idbout, *idsines;
	int	nfreqs, hanning, ncoefs, dbout;
	float	curq, *sinp, *cosp, *linbufp;
	int     countdown, timcount, winlen[MAXFRQS];
	WINDAT  dwindow;
	AUXCH	auxch;
} NOCTDFT;
#endif

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	float	*iprd, *iwtflg;
	int     countdown, timcount;
	WINDAT  dwindow;
} SPECDISP;

#define MAXPTL 10

typedef struct {
	OPDS	h;
	float	*koct, *kamp;
	SPECDAT *wsig;
	float	*kvar, *ilo, *ihi, *istrt, *idbthresh, *inptls, *irolloff;
	float	*iodd, *iconf, *interp, *ifprd, *iwtflg;
	int	pdist[MAXPTL], nptls, rolloff, kinterp, ftimcnt;
	float	pmult[MAXPTL], confact, kvalsav, kval, kavl, kinc, kanc;
	float   *flop, *fhip, *fundp, *oct0p, threshon, threshoff;
	int	winpts, jmpcount, playing;
	SPECDAT	wfund;
	SPECDISP fdisplay;
} SPECPTRK;

typedef struct {
	OPDS	h;
	float	*ksum;
	SPECDAT *wsig;
	float   *interp;
	int     kinterp;
	float	kval, kinc;
} SPECSUM;

typedef struct {
	OPDS	h;
	SPECDAT	*waddm;
	SPECDAT *wsig1, *wsig2;
	float   *imul2;
	float	mul2;
} SPECADDM;

typedef struct {
	OPDS	h;
	SPECDAT *wdiff;
	SPECDAT *wsig;
	SPECDAT specsave;
} SPECDIFF;

typedef struct {
	OPDS	h;
	SPECDAT *wscaled;
	SPECDAT *wsig;
	float	*ifscale, *ifthresh;
	int	thresh;
	float	*fscale, *fthresh;
	AUXCH	auxch;
} SPECSCAL;

typedef struct {
	OPDS	h;
	SPECDAT *wacout;
	SPECDAT *wsig;
	SPECDAT accumer;
} SPECHIST;

typedef struct {
	OPDS	h;
	SPECDAT *wfil;
	SPECDAT *wsig;
	float	*ifhtim;
	float   *coefs, *states;
	AUXCH	auxch;
} SPECFILT;



extern void spectset (SPECTRUM *p);
extern void spectrum (SPECTRUM *p);
extern void spdspset (SPECDISP *p);
extern void specdisp (SPECDISP *p);
extern void sptrkset (SPECPTRK *p);
extern void specptrk (SPECPTRK *p);
extern void spsumset (SPECSUM *p);
extern void specsum (SPECSUM *p);
extern void spadmset (SPECADDM *p);
extern void specaddm (SPECADDM *p);
extern void spdifset (SPECDIFF *p);
extern void specdiff (SPECDIFF *p);
extern void spsclset (SPECSCAL *p);
extern void specscal (SPECSCAL *p);
extern void sphstset (SPECHIST *p);
extern void spechist (SPECHIST *p);
extern void spfilset (SPECFILT *p);
extern void specfilt (SPECFILT *p);


#endif __spectra_h__

