#ifndef __pluck_h__
#define __pluck_h__


/* pluck.h -- plucked string class declarations */

/*
 * Code conversion from C++ to C (October 1994)
 * Author: Michael A. Casey MIT Media Labs
 * Language: C
 * Copyright (c) 1994 MIT Media Lab, All Rights Reserved
 */


#ifndef _pluck_h
#define _pluck_h

#include "wavegde.h"

/* pluck -- derived class to implement simple plucked string algorithm */
typedef struct {
  OPDS h;
  float *out; /* plucked string output */
  float *freq,*amp,*pickupPos,*pickPos,*Aw0,*AwPI,*afdbk; /* inputs */

  waveguide wg;     /* general waveguide model structure   */
  filter bridge;    /* lowpass bridge filter               */
  len_t pickSamp;   /* where to pluck the string           */
  len_t pickupSamp; /* where to record string displacement */

  /* Auxillary memory allocation */
  AUXCH upperData;    /* upper rail data space */
  AUXCH lowerData;    /* lower rail data space */
  AUXCH bridgeCoeffs; /* Bridge filter coefficients */
  AUXCH bridgeData;   /* Bridge filter lattice data */
}WGPLUCK;

/* Plucked string class member functions */
/*void pluckPluck(WGPLUCK*);       /* constructor */
/*void pluckGetSamps(WGPLUCK*);    /* sample generation function */

void pluckExcite(WGPLUCK*);                      /* excitation function  */
sampPtr pluckStop(WGPLUCK*,len_t,paramT,paramT); /*damping sample generation*/
sampPtr pluckShape(WGPLUCK*,paramT);             /* pluck shape function */
sampPtr pluckFlip(WGPLUCK*,sampPtr);             /* flip the shape */
void pluckSetFilters(WGPLUCK*,paramT,paramT);    /* sets filters*/

#endif





extern void pluckPluck (WGPLUCK *plk);
extern void pluckExcite (WGPLUCK *plk);
extern void pluckSetFilters (WGPLUCK *plk, paramT A_w0, paramT A_PI);
extern sampPtr pluckFlip (WGPLUCK *plk, sampPtr a);
extern sampPtr pluckShape (WGPLUCK *plk, paramT amp);
extern void pluckGetSamps (WGPLUCK *plk);


#endif __pluck_h__

