#ifndef __shaker_h__
#define __shaker_h__


/******************************************/  
/*  Maracha (& other shakers) Simulation  */
/*  by Perry R. Cook, 1996		  */
/*  by Perry Cook, 1995-96                */
/*                                        */
/*  See ICMC96 paper "PhISM: Percussive   */
/*  Synthesis." for more exciting details */
/******************************************/

#if !defined(__Shaker_h)
#define __Shaker_h

#include "cs.h"
#include "physutil.h" 

typedef struct Shaker {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amp, *kfreq;
    float	*beancount, *shake_damp;
    float	*times, *dettack;

    BiQuad	filter;
    ADSR	envelope;
    int		num_beans;
    int		wait_time;
    int		shake_num;
    float	shake_speed;    /* A + amp*N -- hides two parameters */
    float	res_freq;
    float	coll_damp;
    float	shakeEnergy;
    float	noiseGain;
    float	gain_norm;
    int		kloop;
    float       freq;
} SHAKER;

#endif




extern void shakerset (SHAKER *p);
extern void shaker (SHAKER *p);


#endif __shaker_h__

