#ifndef __one_zero_h__
#define __one_zero_h__

/*******************************************/
/*  One Zero Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */ 
/*  The parameter gain is an additional    */
/*  gain parameter applied to the filter   */  
/*  on top of the normalization that takes */
/*  place automatically.  So the net max   */
/*  gain through the system equals the     */
/*  value of gain.  sgain is the combina-  */
/*  tion of gain and the normalization     */
/*  parameter, so if you set the poleCoeff */
/*  to alpha, sgain is always set to       */
/*  gain / (1.0 - fabs(alpha)).            */
/*******************************************/

typedef struct OneZero {
    float gain;                 /* Filter subclass */
    float inputs;
    float lastOutput;           /* End of Filter */
    float zeroCoeff;
    float sgain;
} OneZero;

extern void make_OneZero (OneZero *z);
extern float OneZero_tick (OneZero *z, float sample);
extern void OneZero_setCoeff (OneZero *z, float aValue);
extern void OneZero_print (OneZero *p);


#endif __one_zero_h__

