#ifndef __modal4_h__
#define __modal4_h__

/*******************************************/
/*  4 Resonance Modal Synthesis Module */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains an excitation */
/*  wavetable, an envelope, and four reso- */
/*  nances (Non-Sweeping BiQuad Filters).  */
/*******************************************/

#include "cs.h"
#include "physutil.h"

typedef struct Modal4 {
    Envelope envelope; 
    FUNC	*wave;
/*     int		w_looping; */
    int 	w_myData;
    int 	w_allDone;
    float 	w_rate;
    float 	w_time;
    float 	w_phaseOffset;
    float 	w_lastOutput;
    BiQuad      filters[4];
    OnePole     onepole;
    FUNC	*vibr;
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
    float	v_phaseOffset;
    float	v_lastOutput;
    float	vibrGain;
    float	masterGain;
    float	directGain;
    float	baseFreq;
    float	ratios[4];
    float	resons[4];
} Modal4;

#define Modal4_setMasterGain(m,Gain)	(m->masterGain = aGain)
#define Modal4_setDirectGain(m,aGain)	(m->directGain = aGain)
#define Modal4_setFiltGain(m,whichOne,gain) (BiQuad_setGain(m->filters[whichOne], gain))

extern void make_Modal4 (Modal4 *m, float *ifn, float vgain, float vrate);
extern void Modal4_setFreq (Modal4 *m, float frequency);
extern void Modal4_setRatioAndReson (Modal4 *m, int whichOne, float ratio, float reson);
extern void Modal4_strike (Modal4 *m, float amplitude);
extern void Modal4_damp (Modal4 *m, float amplitude);
extern float Modal4_tick (Modal4 *m);


#endif __modal4_h__

