#ifndef __midiops2_h__
#define __midiops2_h__


/****************************************/
/** midicXX   UGs by Gabriel Maldonado **/
/****************************************/

typedef struct {
    OPDS   h;
    float  *r, *ictlno, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno;
} MIDICTL2;


typedef struct {
    OPDS   h;
    float  *r, *ictlno1, *ictlno2, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno1, ctlno2;
} MIDICTL3;

typedef struct {
    OPDS   h;
    float  *r, *ictlno1, *ictlno2, *ictlno3, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno1, ctlno2, ctlno3;
} MIDICTL4;

/*----------------------------------------*/
/* GLOBAL MIDI IN CONTROLS activable by score-oriented instruments*/

typedef struct {
    OPDS   h;
    float  *r, *ichan, *ictlno, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno;
} CTRL7;

typedef struct {
    OPDS   h;
    float  *r, *ichan, *ictlno1, *ictlno2, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno1, ctlno2;
} CTRL14;

typedef struct {
    OPDS   h;
    float  *r, *ichan, *ictlno1, *ictlno2, *ictlno3, *imin, *imax, *ifn;
    short flag;
    FUNC *ftp;
    long   ctlno1, ctlno2, ctlno3;
} CTRL21;


typedef struct {
    OPDS   h;
    float  *ichan, *ictlno, *ivalue;
} INITC7;

typedef struct {
    OPDS   h;
    float  *ichan, *ictlno1, *ictlno2, *ivalue;
} INITC14;

typedef struct {
    OPDS   h;
    float  *ichan, *ictlno1, *ictlno2, *ictlno3, *ivalue;
} INITC21;
/* gab-A1 */
typedef struct {
    OPDS   h;
    float  *status, *chan, *data1, *data2;
	unsigned long local_buf_index;
} MIDIIN;
/* end gab-A1 */


extern void imidic7 (MIDICTL2 *p);
extern void midic7set (MIDICTL2 *p);
extern void midic7 (MIDICTL2 *p);
extern void imidic14 (MIDICTL3 *p);
extern void midic14set (MIDICTL3 *p);
extern void midic14 (MIDICTL3 *p);
extern void imidic21 (MIDICTL4 *p);
extern void midic21set (MIDICTL4 *p);
extern void midic21 (MIDICTL4 *p);
extern void ictrl7 (CTRL7 *p);
extern void ctrl7set (CTRL7 *p);
extern void ctrl7 (CTRL7 *p);
extern void ictrl14 (CTRL14 *p);
extern void ctrl14set (CTRL14 *p);
extern void ctrl14 (CTRL14 *p);
extern void ictrl21 (CTRL21 *p);
extern void ctrl21set (CTRL21 *p);
extern void ctrl21 (CTRL21 *p);
extern void initc7 (INITC7 *p);
extern void initc14 (INITC14 *p);
extern void initc21 (INITC21 *p);
extern void midiin_set (MIDIIN *p);
extern void midiin (MIDIIN *p);


#endif __midiops2_h__

