#ifndef __marimba_h__
#define __marimba_h__

/*******************************************/
/*  Marimba SubClass of Modal4 Module, */
/*  by Perry R. Cook, 1995-96              */ 
/*                                         */
/*   Controls:               stickHardness */
/*                           strikePosition*/
/*		             vibFreq       */
/*		             vibAmt        */
/*******************************************/

#include "modal4.h"

typedef struct Marimba {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amplitude, *frequency;
    float	*hardness, *spos, *ifn;
    float	*vibFreq, *vibAmt, *ivfn, *dettack;

/* Modal4 */
    Modal4	m4;
    int		multiStrike;  
    float	strikePosition;
    float 	stickHardness;
    int		kloop;
} MARIMBA;

extern void marimbaset (MARIMBA *p);
extern void marimba (MARIMBA *p);


#endif __marimba_h__

