#include <string.h>
#include <unistd.h>

#include "cs.h"
#include "entry.h"
#include "insert.h"
#include "auxfd.h"
#include "dumpf.h"
#include "filopen.h"

void
kdmpset(KDUMP * p)
{
	if (*p->ifilcod == sstrcod) {	/* open in curdir or pathname */
		if ((p->fdch.fd = openout(p->STRARG, 1)) < 0) {
			error << "INIT: cannot open " << retfilnam << endmsg;

			return;
		}
		fdrecord(&p->fdch);
		if ((p->format = (int) *p->iformat) < 1 || p->format > 8)
			error << "INIT: unknown format request" << endmsg;

		if (p->format == 2 || p->format == 3)
			error << "INIT: alaw and ulaw not implemented here" << endmsg;

		if ((p->timcount = (long) (*p->iprd * ekr)) <= 0)
			p->timcount = 1;
		p->countdown = p->timcount;
	} else
		error << "INIT: need quoted filename" << endmsg;

}

void
kdmp2set(KDUMP2 * p)
{
	if (*p->ifilcod == sstrcod) {	/* open in curdir or pathname */
		if ((p->fdch.fd = openout(p->STRARG, 1)) < 0) {
			error << "INIT: cannot open " << retfilnam << endmsg;

			return;
		}
		fdrecord(&p->fdch);
		if ((p->format = (int) *p->iformat) < 1 || p->format > 8)
			error << "INIT: unknown format request" << endmsg;

		if (p->format == 2 || p->format == 3)
			error << "INIT: alaw and ulaw not implemented here" << endmsg;

		if ((p->timcount = (long) (*p->iprd * ekr)) <= 0)
			p->timcount = 1;
		p->countdown = p->timcount;
	} else
		error << "INIT: need quoted filename" << endmsg;

}

void
kdmp3set(KDUMP3 * p)
{
	if (*p->ifilcod == sstrcod) {	/* open in curdir or pathname */
		if ((p->fdch.fd = openout(p->STRARG, 1)) < 0) {
			error << "INIT: cannot open " << retfilnam << endmsg;

			return;
		}
		fdrecord(&p->fdch);
		if ((p->format = (int) *p->iformat) < 1 || p->format > 8)
			error << "INIT: unknown format request" << endmsg;

		if (p->format == 2 || p->format == 3)
			error << "INIT: alaw and ulaw not implemented here" << endmsg;

		if ((p->timcount = (long) (*p->iprd * ekr)) <= 0)
			p->timcount = 1;
		p->countdown = p->timcount;
	} else
		error << "INIT: need quoted filename" << endmsg;

}

void
kdmp4set(KDUMP4 * p)
{
	if (*p->ifilcod == sstrcod) {	/* open in curdir or pathname */
		if ((p->fdch.fd = openout(p->STRARG, 1)) < 0) {
			error << "INIT: cannot open " << retfilnam << endmsg;

			return;
		}
		fdrecord(&p->fdch);
		if ((p->format = (int) *p->iformat) < 1 || p->format > 8)
			error << "INIT: unknown format request" << endmsg;

		if (p->format == 2 || p->format == 3)
			error << "INIT: alaw and ulaw not implemented here" << endmsg;

		if ((p->timcount = (long) (*p->iprd * ekr)) <= 0)
			p->timcount = 1;
		p->countdown = p->timcount;
	} else
		error << "INIT: need quoted filename" << endmsg;

}

static float kval[4];		/* handle up to four ksig arguments */

static void
nkdump(int ofd, int format, int nk)
{
	char outbuf[80];
	int len;
	float *kp = kval;

	switch (format) {	/* place formatted kvals into outbuf */
	case 1:{
			char *bp = outbuf;
			len = nk;
			while (nk--)
				*bp++ = (char) (*kp++ / 256.0f);
			break;
		}
	case 4:{
			short *bp = (short *) outbuf;
			len = nk * sizeof (short);
			while (nk--)
				*bp++ = (short) *kp++;
			break;
		}
	case 5:{
			long *bp = (long *) outbuf;
			len = nk * sizeof (long);
			while (nk--)
				*bp++ = (long) *kp++;
			break;
		}
	case 6:{
			float *bp = (float *) outbuf;
			len = nk * sizeof (float);
			while (nk--)
				*bp++ = *kp++;
			break;
		}
	case 7:
		*outbuf = '\0';
		while (--nk) {
			error << "" << (long) *kp++ << "\t" << endmsg;

		}
		error << "" << (long) *kp << "\n" << endmsg;

		len = strlen(outbuf);
		break;
	case 8:
		*outbuf = '\0';
		while (--nk) {
			error << "" << *kp++ << "\t" << endmsg;

		}
		error << "" << *kp << "\n" << endmsg;

		len = strlen(outbuf);
		break;
	default:
		fatal << "unknown kdump format" << endmsg;

	}
	write(ofd, outbuf, len);	/* now write the buffer */
}

void
kdump(KDUMP * p)
{
	if (--p->countdown <= 0) {
		p->countdown = p->timcount;
		kval[0] = *p->ksig;
		nkdump(p->fdch.fd, p->format, 1);
	}
}

void
kdump2(KDUMP2 * p)
{
	if (--p->countdown <= 0) {
		p->countdown = p->timcount;
		kval[0] = *p->ksig1;
		kval[1] = *p->ksig2;
		nkdump(p->fdch.fd, p->format, 2);
	}
}

void
kdump3(KDUMP3 * p)
{
	if (--p->countdown <= 0) {
		p->countdown = p->timcount;
		kval[0] = *p->ksig1;
		kval[1] = *p->ksig2;
		kval[2] = *p->ksig3;
		nkdump(p->fdch.fd, p->format, 3);
	}
}

void
kdump4(KDUMP4 * p)
{
	if (--p->countdown <= 0) {
		p->countdown = p->timcount;
		kval[0] = *p->ksig1;
		kval[1] = *p->ksig2;
		kval[2] = *p->ksig3;
		kval[3] = *p->ksig4;
		nkdump(p->fdch.fd, p->format, 4);
	}
}





OENTRY opcodes[] =
{
	{"kdump", S(KDUMP), 3, "", "kSii", F(kdmpset), F(kdump)},
	{"kdump2", S(KDUMP2), 3, "", "kkSii", F(kdmp2set), F(kdump2)},
	{"kdump3", S(KDUMP3), 3, "", "kkkSii", F(kdmp3set), F(kdump3)},
	{"kdump4", S(KDUMP4), 3, "", "kkkkSii", F(kdmp4set), F(kdump4)},
	{NULL}
};
