#ifndef __disprep_h__
#define __disprep_h__


        		/*					DISPREP.H	*/

typedef struct {
	OPDS	h;
	float	*iargs[VARGMAX];
} PRINTV;

typedef struct {
	OPDS	h;
	float	*signal, *iprd, *inprds, *iwtflg;
	long	npts, nprds, bufpts, totpts, pntcnt;
	WINDAT  dwindow;
	float	*nxtp, *begp, *endp;
	AUXCH	auxch;
} DSPLAY;

#define	WINDMAX	4096
#define WINDMIN 16

typedef struct {
	OPDS	h;
	float	*signal, *iprd, *inpts, *ihann, *idbout, *iwtflg;
	float	sampbuf[WINDMAX], *bufp, *endp, *fftlut, overN;
	long	windsize, overlap, ncoefs;
	int	hanning, dbout;
	WINDAT  dwindow;
	AUXCH	auxch;
} DSPFFT;

typedef struct {
	OPDS	h;
	float	*kout,*kin,*iprd,*imindur,*imemdur,*ihp,*ithresh,*ihtim,*ixfdbak;
	float   *istartempo,*ifn,*idisprd,*itweek;
	int     countdown, timcount, npts, minlam, maxlam;
	float	*hbeg, *hcur, *hend;
	float	*xbeg, *xcur, *xend;
	float	*stmemp, *linexp, *ftable, *xscale, *lmults;
	short   *lambdas;
	float   *stmemnow, ncross, coef0, coef1, yt1, thresh;
	float   fwdcoef, fwdmask, xfdbak, avglam, tempscal, tempo, tweek;
	int     dcntdown, dtimcnt;
	WINDAT  dwindow;
	AUXCH	auxch;
} TEMPEST;




extern void printv (PRINTV *p);
extern void dspset (DSPLAY *p);
extern void kdsplay (DSPLAY *p);
extern void dsplay (DSPLAY *p);
extern void fftset (DSPFFT *p);
extern void kdspfft (DSPFFT *p);
extern void dspfft (DSPFFT *p);
extern void tempeset (TEMPEST *p);
extern void tempest (TEMPEST *p);


#endif __disprep_h__

