/******************************************/
/*  Simple Brass Module Model ala     */
/*  Cook (TBone, HosePlayer)              */
/*  by Perry R. Cook, 1995-96             */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/*   Controls:    CONTROL1 = lipTension   */
/*                CONTROL2 = slideLength  */
/*		  CONTROL3 = vibFreq      */
/*		  MOD_WHEEL= vibAmt       */
/******************************************/

#if !defined(__Brass_h)
#define __Brass_h

#include "physutil.h"
#include "cs.h"
#include <math.h>

/*******************************************/
/*                                         */
/*  AllPass Interpolating Delay Line       */
/*  Object by Perry R. Cook 1995-96        */
/*  This one uses a delay line of maximum  */
/*  length specified on creation, and      */ 
/*  interpolates fractional length using   */
/*  an all-pass filter.  This version is   */
/*  more efficient for computing static    */
/*  length delay lines (alpha and coeff    */
/*  are computed only when the length      */  
/*  is set, there probably is a more       */ 
/*  efficient computational form if alpha  */
/*  is changed often (each sample)).       */
/*                                         */
/*******************************************/


typedef struct DLineA {
    AUXCH	inputs;
    float	lastOutput;
    long	inPoint;
    long	outPoint;
    long	length;
    float	alpha;
    float	coeff;
    float	lastIn;
} DLineA;

void make_DLineA(DLineA *, long max_length);
void DLineA_clear(DLineA *);
void DLineA_setDelay(DLineA *, float length);
float DLineA_tick(DLineA *, float sample);

/**********************************************/
/*  Lip Filter Object by Perry R. Cook, 1995-96*/    
/*  The lip of the brass player has dynamics  */
/*  which are controlled by the mass, spring  */
/*  constant, and damping of the lip.  This   */
/*  filter simulates that behavior and the    */
/*  transmission/reflection properties as     */
/*  well.  See Cook TBone and HosePlayer      */
/*  instruments and articles.                 */
/**********************************************/

typedef BiQuad LipFilt;

void make_LipFilt(LipFilt*);
void LipFilt_clear(LipFilt*);
void LipFilt_setFreq(LipFilt*, float frequency);
float LipFilt_tick(LipFilt*, float mouthSample,float boreSample);
float LipFilt_lastOut(LipFilt*);

  
/* ---------------------------------------------------------------------- */
typedef struct BRASS {
    OPDS    h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*liptension, *dettack;
    float	*vibFreq, *vibAmt, *ifn, *lowestFreq; 

    FUNC	*vibr;          /* Table for vibrato */
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
/*     float	v_phaseOffset; */
    DLineA	delayLine;
    LipFilt	lipFilter;
    DCBlock	dcBlock;
    ADSR	adsr;
    long	length;
    float	slideTarget;
    float	maxPressure;
    float	lipTarget;
    float	frq;            /* Remember previous value */
    float	lipT;           /* and lip tension */
    int		kloop;
} BRASS;

#endif
