/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is int16ended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: ugens5.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __cs_ugens5_h__
#define __cs_ugens5_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(PORT)
	Number	*kr, *ksig, *ihtim, *isig;
	Number	c1, c2, yt1;
};

OpcodeArgument(TONE)
	Number	*ar, *asig, *khp, *istor;
	Number	c1, c2, yt1, prvhp;
};

OpcodeArgument(RESON)
	Number	*ar, *asig, *kcf, *kbw, *iscl, *istor;
	int16     scale;
	Number	c1, c2, c3, yt1, yt2, cosf, prvcf, prvbw;
};

OpcodeArgument(TONEX)
	Number	*ar, *asig, *khp, *ord, *istor;
	Number	c1, c2, *yt1, prvhp;
	int16 loop;
        AUXCH	aux;
};

OpcodeArgument(RESONX)
	Number	*ar, *asig, *kcf, *kbw, *ord, *iscl, *istor;
	int16     scale, loop;
	Number	c1, c2, c3, *yt1, *yt2, cosf, prvcf, prvbw;
        AUXCH	aux;
};

OpcodeArgument(RMS)
	Number	*kr, *asig, *ihp, *istor;
	Number	c1, c2, prvq;
};

OpcodeArgument(GAIN)
	Number	*ar, *asig, *krms, *ihp, *istor;
	Number	c1, c2, prvq, prva;
};

OpcodeArgument(BALANCE)
	Number	*ar, *asig, *csig, *ihp, *istor;
	Number	c1, c2, prvq, prvr, prva;
};

extern void porset (PORT *);
extern void port (PORT *);
extern void tonset (TONE *);
extern void tone (TONE *);
extern void atone (TONE *);
extern void tonsetx (TONEX *);
extern void tonex (TONEX *);
extern void atonex (TONEX *);
extern void rsnset (RESON *);
extern void reson (RESON *);
extern void rsnsetx (RESONX *);
extern void resonx (RESONX *);
extern void areson (RESON *);
extern void rmsset (RMS *);
extern void rms (RMS *);
extern void gainset (GAIN *);
extern void gain (GAIN *);
extern void balnset (BALANCE *);
extern void balance (BALANCE *);

#define UGENS5_OPCODE_LIST \
{ "port",   S(PORT), InitTime|EventTime,	"k",	"Xio", \
	  F(porset), F(port), NULL }, \
{ "tone",   S(TONE), InitTime|AudioTime,	"a",	"aXo", \
	  F(tonset), NULL, F(tone) }, \
{ "tonex",  S(TONEX), InitTime|AudioTime,      "a",    "aXoo", \
	  F(tonsetx), NULL,  F(tonex) }, \
{ "atone",  S(TONE), InitTime|AudioTime,	"a",	"aXo", \
	  F(tonset), NULL, F(atone) }, \
{ "atonex", S(TONEX), InitTime|AudioTime,      "a",    "aXoo", \
	  F(tonsetx), NULL, F(atonex) }, \
{ "reson",  S(RESON), InitTime|AudioTime,	"a",	"aXXoo", \
	  F(rsnset), NULL, F(reson) }, \
{ "resonx", S(RESONX),InitTime|AudioTime,      "a",    "aXXooo", \
	  F(rsnsetx), NULL, F(resonx) }, \
{ "areson", S(RESON), InitTime|AudioTime,	"a",	"aXXoo", \
	  F(rsnset), NULL, F(areson) }, \
{ "rms",    S(RMS), InitTime|EventTime,	"k",	"aqo", \
	  F(rmsset), F(rms), NULL }, \
{ "gain",   S(GAIN), InitTime|AudioTime,	"a",	"aXqo", \
	  F(gainset), NULL, F(gain) }, \
{ "balance",S(BALANCE),	InitTime|AudioTime,	"a",	"aaqo", \
	  F(balnset), NULL, F(balance) }

#endif __cs_ugens5_h__
