/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: ugens3.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __ugens3_h__
#define __ugens3_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>
#include <quasimodo/dynamic_memory.h>
#include <quasimodo/memfile.h>

OpcodeArgument(FOSC)
	Number	*rslt, *xamp, *kcps, *kcar, *kmod, *kndx, *ifn, *iphs;
	int32	mphs, cphs;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(LOSC)
	Number	*ar1,*ar2,*xamp,*kcps,*ifn,*ibas,*imod1,*ibeg1,*iend1,*imod2,*ibeg2,*iend2;
	Number	cpscvt;
	int32	lphs;
	int16	mod1, mod2;
	int32	beg1, beg2;
	int32	end1, end2;
	int16	seg1, curmod, looping, stereo;
	RCPointer<FunctionTable> ftp;
};

struct DUPLE {
	int16	tim;
	int16	val;
};

struct PTLPTR {
        PTLPTR *nxtp;
	DUPLE	*ap;
	DUPLE	*fp;
	int16	amp,frq;
	int32	phs;
};

#define MAXPTLS 50    /* must agree with hetro.c */

OpcodeArgument(ADSYN)
	Number	*rslt, *kamod, *kfmod, *ksmod, *ifilcod, *dum;
	RCPointer<MemoryMappedFile> mfp;
	int32	mksecs;
        AUXCH   aux;
};

extern void foscset (FOSC *p);
extern void foscil (FOSC *p);
extern void foscili (FOSC *p);
extern void losset (LOSC *p);
extern void loscil (LOSC *p);
extern void adset (ADSYN *p);
extern void adsyn (ADSYN *p);

#define UGENS3_OPCODE_LIST \
	{"foscil", S(FOSC), InitTime|EventTime, "a", "xkkkkFo", \
	 F(foscset), NULL, F(foscil)}, \
	{"foscili", S(FOSC), InitTime|EventTime, "a", "xkkkkFo", \
	 F(foscset), NULL, F(foscili)}, \
	{"loscil", S(LOSC), InitTime|EventTime, "mm", "xkFojoojoo", \
	 F(losset), NULL, F(loscil)}, \
	{"adsyn", S(ADSYN), InitTime|EventTime, "a", "kkkio", \
	 F(adset), NULL, F(adsyn)}

#endif __ugens3_h__

