/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: streson.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __qm_streson_h__
#define __qm_streson_h__

/****************************************************/
/* streson.h : string resonator header file         */
/*                                                  */
/*           Victor Lazzarini, 1998                 */
/****************************************************/

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(STRES)
	Number	*result, *ainput, *afr, *ifdbgain;
	Number	LPdelay, APdelay, *Cdelay;
        AUXCH	aux;
        int32	wpointer, rpointer, vdtime, size;
};

extern
void
stresonset(STRES *p);

extern
void
streson(STRES *p);

#define STRESON_OPCODE_LIST \
{ "streson", S(STRES), InitTime|EventTime, "a", "aki",   \
     F(stresonset), NULL, F(streson)  }


#endif  __qm_streson_h__
