/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: random.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __qm_random_h__
#define __qm_random_h__

#define RANDINT_MAX  2147483647L   /* 2**31 - 1 = 0x7FFFFFFF */ 
#define RANDINT_MULT 16807        /* multiplier */

#define unirand()  (float)((double)randint31()/(double)RANDINT_MAX)

extern long seed31;
extern long randint31();

extern float unifrand(float range);
extern float linrand(float range);
extern float trirand(float range);
extern float exprand(float l);
extern float biexprand(float l);
extern float gaussrand(float s);
extern float cauchrand(float a);
extern float pcauchrand(float a);
extern float betarand(float range, float a, float b);
extern float weibrand(float s, float t);
extern float poissrand(float l);

#endif  __qm_random_h__
