/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: midiops.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __midiops_h__
#define __midiops_h__

#include <quasimodo/opcode_defs.h>

#define NOTEOFF_TYPE  0x80
#define NOTEON_TYPE   0x90
#define POLYAFT_TYPE  0xA0
#define CONTROL_TYPE  0xB0
#define PROGRAM_TYPE  0xC0
#define AFTOUCH_TYPE  0xD0
#define PCHBEND_TYPE  0xE0
#define SYSTEM_TYPE   0xF0

#define MAXCHAN       96        /* for 6 ports */

#define DATENABL        3       /* unused ctl_val spc */
#define DATENTRY        6
#define VOLUME          7
#define MOD_VOLUME      9       /* unused ctl_val spc */
#define SUSTAIN_SW      64
#define NRPNLSB         98
#define NRPNMSB         99
#define RPNLSB          100
#define RPNMSB          101

#define VIB_RATE        102     /* ROLAND EXTENDED CTRLS */
#define VIB_DEPTH       103     /* in unused ctl_val spc */
#define VIB_DELAY       104
#define TVF_CUTOFF      105
#define TVF_RESON       106 
#define TVA_RIS         107
#define TVA_DEC         108
#define TVA_RLS         109

#define BENDSENS        110     /* unused ctl_val spc */

OpcodeArgument(MASSIGN)
    Number  *chnl, *module_id;
};

OpcodeArgument(CTLINIT)
    Number  *chnl, *ctrls[64];
};

OpcodeArgument(MIDIVAL)
    Number  *r, *irange;		/* MWB addition */
    Number  iscal;
};

OpcodeArgument(MIDIAMP)
    Number  *r, *imax, *ifn;
};

OpcodeArgument(MIDISCL)
    Number  *r, *iscal;
    Number  scale;
};

OpcodeArgument(MIDICTL)
    Number  *r, *ictlno, *ilo, *ihi;
    long   ctlno;
    Number  scale, lo;
};

OpcodeArgument(CHANCTL)
    Number  *r, *ichano, *ictlno, *ilo, *ihi;
    long   chano, ctlno;
    Number  scale, lo;
};

OpcodeArgument(MIDIMAP)
    Number  *r, *ilo, *ihi;
};

OpcodeArgument(MIDIKMAP)
    Number  *r, *ilo, *ihi;
    Number  scale, lo;
};

OpcodeArgument(MIDIOLAP)
    Number  *olap;
};

OpcodeArgument(MIDIAGE)
    Number  *r;
};

OpcodeArgument(CPSTABLE)
	Number *r, *tablenum;
            /*, *numgrades, *interval, *basefreq, *basekeymidi; */
};

extern void massign (MASSIGN *p);
extern void ctrlinit (CTLINIT *p);
extern void notnum (MIDIVAL *p);
extern void cpstmid (CPSTABLE *p);
extern void veloc (MIDIMAP *p);
extern void pchmidi (MIDIVAL *p);
extern void pchmidib (MIDIVAL *p);
extern void pchmidib_i (MIDIVAL *p);
extern void octmidi (MIDIVAL *p);
extern void octmidib (MIDIVAL *p);
extern void octmidib_i (MIDIVAL *p);
extern void cpsmidi (MIDIVAL *p);
extern void cpsmidib (MIDIVAL *p);
extern void cpsmidib_i (MIDIVAL *p);
extern void ampmidi (MIDIAMP *p);
extern void midibset (MIDIVAL *p);
extern void midikset (MIDIKMAP *p);
extern void aftouch (MIDIKMAP *p);
extern void imidictl (MIDICTL *p);
extern void mctlset (MIDICTL *p);
extern void midictl (MIDICTL *p);
extern void ichanctl (CHANCTL *p);
extern void chctlset (CHANCTL *p);
extern void chanctl (CHANCTL *p);
extern void ipchbend (MIDIMAP *p);
extern void kbndset (MIDIKMAP *p);
extern void kpchbend (MIDIKMAP *p);

#define MIDIOPS_OPCODE_LIST \
{"notnum", S(MIDIVAL),InitTime, "X", "", F(notnum), NULL,  \
NULL, OP_REQUIRES_MIDI}, \
{"veloc", S(MIDIMAP),InitTime, "X", "oh", F(veloc), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"pchmidi", S(MIDIVAL),InitTime, "X", "", F(pchmidi), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"octmidi", S(MIDIVAL),InitTime, "X", "", F(octmidi), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"cpsmidi", S(MIDIVAL),InitTime, "X", "", F(cpsmidi), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"pchmidib_i", S(MIDIVAL),InitTime, "X", "o", F(pchmidib_i), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"octmidib_i", S(MIDIVAL),InitTime, "X", "o", F(octmidib_i), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"cpsmidib_i", S(MIDIVAL),InitTime, "X", "o", F(cpsmidib_i), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"pchmidib_k", S(MIDIVAL),InitTime, "k", "o", F(midibset), F(pchmidib), \
NULL, OP_REQUIRES_MIDI}, \
{"octmidib_k", S(MIDIVAL),EventTime, "k", "o", F(midibset), F(octmidib), \
NULL, OP_REQUIRES_MIDI}, \
{"cpsmidib_k", S(MIDIVAL),EventTime, "k", "o", F(midibset), F(cpsmidib), \
NULL, OP_REQUIRES_MIDI}, \
{"ampmidi", S(MIDIAMP), InitTime, "X", "io", F(ampmidi), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"aftouch", S(MIDIKMAP), InitTime|EventTime, "k", "oh", \
F(midikset), F(aftouch), NULL, OP_REQUIRES_MIDI}, \
{"pchbend_i", S(MIDIMAP), InitTime, "i", "jp", F(ipchbend), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"pchbend_k", S(MIDIKMAP), EventTime, "k", "jp", F(kbndset), F(kpchbend), \
NULL, OP_REQUIRES_MIDI}, \
{"midictrl_i", S(MIDICTL), InitTime, "i", "ioh", F(imidictl), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"midictrl_k", S(MIDICTL), EventTime, "k", "ioh", F(mctlset), F(midictl),  \
NULL, OP_REQUIRES_MIDI}, \
{"chanctrl_i", S(CHANCTL), InitTime, "i", "iioh", F(ichanctl), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"chanctrl_k", S(CHANCTL), EventTime, "k", "iioh", F(chctlset), F(chanctl), \
NULL, OP_REQUIRES_MIDI}, \
{"cpstmid", S(CPSTABLE), InitTime, "i", "i", F(cpstmid), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"ctrlinit", S(CTLINIT), InitTime, "", "im", F(ctrlinit), NULL, \
NULL, OP_REQUIRES_MIDI}, \
{"massign", S(MASSIGN), InitTime, "", "ii", F(massign), NULL, \
NULL, OP_REQUIRES_MIDI}

#endif __midiops_h__ 

