/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: midiops.cc,v 1.3 1999/11/29 18:49:28 pbd Exp $
*/


#include <math.h>

#include <midi++/types.h>
#include <midi++/channel.h>
#include <midi++/port.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>
#include <quasimodo/process.h>

#include "midiops.h"

static const Number dv127 = (1.0f/127.0f);

void
massign(MASSIGN * p)
{
	if (*p->chnl > 0) {
		warning << "massign: this doesn't do anything in Quasimodo" 
			<< endmsg;
		*p->chnl = 0;
	}
}

void
ctrlinit(CTLINIT * p)
{
	MIDI::channel_t chnl = (MIDI::channel_t) (*p->chnl - 1.0f);
	MIDI::Channel *mchnl = p->PROCESS->midi_port()->channel (chnl);

	short nargs = p->INOCOUNT;

	if ((nargs & 0x1) == 0)
		p->error ("ctrlinit: uneven ctrl pairs");
	else {
		Number **argp = p->ctrls;
		short ctlno, nctls = nargs >> 1;

		do {
			ctlno = (short) **argp++;
			mchnl->set_controller (ctlno, (byte) **argp++);
		} while (--nctls);
	}
}

void
notnum(MIDIVAL * p)
{				/* valid only at I-time */
	*p->r = p->PROCESS->midi_pitch();
}

void
veloc(MIDIMAP * p)
{				/* valid only at I-time */
	*p->r = *p->ilo + p->PROCESS->midi_velocity() *
		(*p->ihi - *p->ilo) * dv127;
}

void
pchmidi(MIDIVAL * p)
{
	double fract, oct, ioct;
	oct = p->PROCESS->midi_pitch() / 12.0 + 3.0;
	fract = modf(oct, &ioct);
	fract *= 0.12;
	*p->r = (Number) (ioct + fract);
}

void
pchmidib(MIDIVAL * p)
{
	double fract, oct, ioct;
	oct = (p->PROCESS->midi_pitch() +
	       (p->PROCESS->midi_channel()->pitchbend() * p->iscal)) /
	    12. + 3.;
	fract = modf(oct, &ioct);
	fract *= 0.12;
	*p->r = (Number) (ioct + fract);
}

void pchmidib_i(MIDIVAL *p)
{
	midibset(p);
	pchmidib(p);
}

void
octmidi(MIDIVAL * p)
{
	*p->r = p->PROCESS->midi_pitch() / 12.0f + 3.0f;
}

void octmidib_i(MIDIVAL *p)
{
	midibset(p);
	octmidib(p);
}

void
octmidib(MIDIVAL * p)
{
	*p->r = (p->PROCESS->midi_pitch() +
  	     (p->PROCESS->midi_channel()->pitchbend() * p->iscal)) /
	    12.0f + 3.0f;
}

void
cpsmidi(MIDIVAL * p)
{
	int32 loct;

	loct = (long) 
	    (((p->PROCESS->midi_pitch()/12.0f) + 3.0f) * octresol);

	*p->r = CPSOCTL(loct);
}

void
cpsmidib(MIDIVAL * p)
{
	int32 loct;

	loct = (int32) (((p->PROCESS->midi_pitch() +
			  p->PROCESS->midi_channel()->pitchbend()
			             * p->iscal) /
			 12.0f + 3.0f) *
			octresol);
	*p->r = CPSOCTL(loct);
}

void cpsmidib_i(MIDIVAL *p)
{
	midibset (p);
	cpsmidib (p);
}

void
midibset(MIDIVAL * p)
{
	if (*p->irange > 0) {
		p->iscal = *p->irange;
	} else {
		p->iscal = 2.0f;
	}
}

void
midikset(MIDIKMAP * p)
{
	p->lo = *p->ilo;
	p->scale = (*p->ihi - p->lo) * dv127;
}

void
aftouch(MIDIKMAP * p)
{
	*p->r = p->lo + p->PROCESS->midi_channel()->pressure() * p->scale;
}

void
imidictl(MIDICTL * p)
{
	long ctlno;

	if ((ctlno = (long) *p->ictlno) < 0 || ctlno > 120) {
	    p->error ("illegal controller number");
	} else {
		*p->r = p->PROCESS->midi_channel()->controller_value(ctlno)
		    * (*p->ihi - *p->ilo) * dv127 + *p->ilo;
	}
}

void
mctlset(MIDICTL * p)
{
	long ctlno;

	if ((ctlno = (long) *p->ictlno) < 0 || ctlno > 120) {
		p->error ("illegal controller number");
		return;
	}
	p->ctlno = ctlno;
	p->scale = (*p->ihi - *p->ilo) * dv127;
	p->lo = *p->ilo;

	/* MWB If the controller value is 0, it is initialized to the
	   optional value
	*/

	if (p->PROCESS->midi_channel()->controller_value(p->ctlno) == 0) {
	       p->PROCESS->midi_channel()->set_controller (p->ctlno, p->scale);
	}
}

void
midictl(MIDICTL * p)
{
	*p->r = p->PROCESS->midi_channel()->controller_value (p->ctlno) *
	    p->scale + p->lo;
}


void
ichanctl(CHANCTL * p)
{
	MIDI::byte ctlno = (MIDI::byte) *p->ictlno;
	MIDI::channel_t chan = (MIDI::channel_t) (*p->ichano - 1.0f);

	if (ctlno > 120) {
		p->error ("illegal controller number %d",
			       ctlno);
		return;
	}

	*p->r = p->PROCESS->midi_port()->channel 
		  (chan)->controller_value (ctlno) *
		      (*p->ihi - *p->ilo) * dv127 + *p->ilo;
}

void
chctlset(CHANCTL * p)
{
	return;
}

void
chanctl(CHANCTL * p)
{
	*p->r = (p->PROCESS->midi_channel()->controller_value (p->ctlno) * 
		 p->scale) + p->lo;
}

void
ipchbend(MIDIMAP * p)
{
	*p->r = *p->ilo + (*p->ihi - *p->ilo) *
		p->PROCESS->midi_channel()->pitchbend();
}

void
kbndset(MIDIKMAP * p)
{
	p->lo = *p->ilo;
	p->scale = *p->ihi - *p->ilo;
}

void
kpchbend(MIDIKMAP * p)
{
	*p->r = p->lo +
	    p->PROCESS->midi_channel()->pitchbend() * p->scale;
}

void
ampmidi (MIDIAMP *p) 

{

}

void
cpstmid (CPSTABLE *p)

{
    
}

Opcode opcodes[] =
{
	MIDIOPS_OPCODE_LIST,
	{NULL}
};
