/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: filter.h,v 1.1 1999/11/01 04:29:06 pbd Exp $
*/

#ifndef __filter_h__
#define __filter_h__

/* filter.h */

/* Author: Michael A. Casey
 * Language: C
 * Copyright (C) 1997 Michael A. Casey, MIT Media Lab, All Rights Reserved 
 *
 * Mods by jpff for internal double point precision, and by pbd for
 * use with Quasimodo. No restrictions apply to any of these changes.
 */

#include <quasimodo/opcode_defs.h>
#include <quasimodo/complex.h>
#include <quasimodo/dynamic_memory.h>

#define MAXZEROS 50 /* Allow up to 50th-order digital filters */
#define MAXPOLES 50

/* Csound structure for FILTER opcode */

OpcodeArgument(FILTER)
	
	Number *out;       /* output signal */
	Number *in;        /* input signal */
	Number *nb, *na;   /* filter-order input arguments */
	Number *coeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient input arguments */
	Number *d1,*d2;    /* These allow ZFILTER to access FILTER routines */
	
	int32 numa;         /* i-var p-time storage registers */
	int32 numb;
	
	Dumber dcoeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient double arguments */
	AUXCH delay;     /* delay-line state memory base pointer */  
	Dumber* currPos;  /* delay-line current position pointer */ /* >>Was float<< */
	int32   ndelay;    /* length of delay line (i.e. filter order) */
};

OpcodeArgument(ZFILTER)
	
	Number *out;       /* output signal */
	Number *in;        /* input signal */
	Number *kmagf, *kphsf; /* magnitude and phase pole nudging factors */
	Number *nb, *na;   /* filter-order input arguments */
	Number *coeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient input arguments */
	
	int32 numa;         /* i-var p-time storage registers */
	int32 numb;
	
	Dumber dcoeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient double arguments */
	AUXCH delay;     /* delay-line state memory base pointer */  
	Dumber* currPos;  /* delay-line current position pointer */ /* >>Was float<< */
	int32   ndelay;    /* length of delay line (i.e. filter order) */
	AUXCH roots;     /* pole roots memory for zfilter */
};

struct FPOLAR  {
    double mag;
    double ph;
}; 

/* filter opcode function prototypes */

extern void ifilter (FILTER *flt);
extern void izfilter (ZFILTER *zflt);
extern void afilter (FILTER *flt);
extern void kfilter (FILTER *flt);
extern void azfilter (ZFILTER *zflt);

#define FILTER_OPCODE_LIST \
{"filter2", S(FILTER), InitTime|AudioTime, "a", "aiim", \
	 F(ifilter), NULL, F(afilter)}, \
{"kfilter2", S(FILTER), EventTime, "k", "kiim", \
	 F(ifilter), F(kfilter), NULL}, \
{"zfilter2", S(ZFILTER), InitTime|AudioTime, "a", "akkiim", \
	 F(izfilter), NULL, F(azfilter)}


#endif __filter_h__
