/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: cross2.h,v 1.2 1999/11/10 03:44:12 pbd Exp $
*/

#ifndef __qm_cross2_h__
#define __qm_cross2_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(CON)
  Number	*out, *as, *af, *len, *ovlp, *iwin, *bias;
  AUXCH		mem;
  Number       	*buffer_in1, *buffer_in2, *buffer_out;
  RCPointer<FunctionTable> win;
  Number	*in1, *in2, *w;
  int32		m, count;
};

extern void Xsynthset (CON *p);
extern void Xsynth (CON *p);

#define CROSS2_OPCODE_LIST \
{"cross2", S(CON), InitTime|AudioTime, "a", "aaiiFk", \
        F(Xsynthset), NULL, F(Xsynth) }


#endif __qm_cross2_h__

